/**
 * Copyright (c) 2015 Digi International Inc.,
 * All rights not expressly granted are reserved.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Digi International Inc. 11001 Bren Road East, Minnetonka, MN 55343
 * =======================================================================
 */

#include "mbed.h"
#include "XBeeLib.h"
#if defined(ENABLE_LOGGING)
#include "DigiLoggerMbedSerial.h"
using namespace DigiLog;
#endif

#define REMOTE_NODE_ADDR64_MSB  ((uint32_t)0x0013A200)

#error "Replace next define with the LSB of the remote module's 64-bit address (SL parameter)"
#define REMOTE_NODE_ADDR64_LSB  ((uint32_t)0x01234567)

#error "Replace next define with the remote module's 16-bit address (MY parameter)"
#define REMOTE_NODE_ADDR16      ((uint16_t)0x1111)

#define REMOTE_NODE_ADDR64      UINT64(REMOTE_NODE_ADDR64_MSB, REMOTE_NODE_ADDR64_LSB)

using namespace XBeeLib;

Serial *log_serial;

static void send_broadcast_data(XBee802& xbee)
{
    const char data[] = "send_broadcast_data";
    const uint16_t data_len = strlen(data);

    const TxStatus txStatus = xbee.send_data_broadcast((const uint8_t *)data, data_len);

    if (txStatus == TxStatusSuccess)
        log_serial->printf("send_broadcast_data OK\r\n");
    else
        log_serial->printf("send_broadcast_data failed with %d\r\n", (int) txStatus);
}

static void send_data_to_remote_node(XBee802& xbee, const RemoteXBee802& RemoteDevice)
{
    const char data[] = "send_data_to_remote_node";
    const uint16_t data_len = strlen(data);

    const TxStatus txStatus = xbee.send_data(RemoteDevice, (const uint8_t *)data, data_len);

    if (txStatus == TxStatusSuccess)
        log_serial->printf("send_data_to_remote_node OK\r\n");
    else
        log_serial->printf("send_data_to_remote_node failed with %d\r\n", (int) txStatus);
}

int main()
{
    log_serial = new Serial(DEBUG_TX, DEBUG_RX);
    log_serial->baud(9600);
    log_serial->printf("Sample application to demo how to send unicast and broadcast data with the XBee802\r\n\r\n");
    log_serial->printf(XB_LIB_BANNER);

#if defined(ENABLE_LOGGING)
    new DigiLoggerMbedSerial(log_serial, LogLevelInfo);
#endif

    XBee802 xbee = XBee802(RADIO_TX, RADIO_RX, RADIO_RESET, NC, NC, 9600);

    RadioStatus radioStatus = xbee.init();
    MBED_ASSERT(radioStatus == Success);

    const RemoteXBee802 remoteDevice64b = RemoteXBee802(REMOTE_NODE_ADDR64);
    const RemoteXBee802 remoteDevice16b = RemoteXBee802(REMOTE_NODE_ADDR16);

    send_broadcast_data(xbee);
    send_data_to_remote_node(xbee, remoteDevice64b);
    send_data_to_remote_node(xbee, remoteDevice16b);

    delete(log_serial);
}
