/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "MFS.h"


// DURATION: Zeit in ms nach der weitergezählt wird
// DIGIT_AN: Zeit nach der das Digit weitergeschaltet wird (Multiplexing)
// verändern Sie die Vorgaben-> "DIGIT_AN 100" und "DURATION 200"
#define DIGIT_AN                                                         2
#define DURATION                                                         100

MFS display;
char seg7[7]={0x01,0x20,0x10,0x08,0x04,0x02,0x01};  // Bitmuster für Ziffer 0 bis 9
int digitAnzeige[4]={0x1000,0x2000,0x4000,0x8000}; // vier 7-Segmentanzeigen von Digit0 bis Digit3

int digitPos = 0;   // Welches der 4 Digits ist ausgewählt
int einer = 0;      // Zahl die auf der Einerstelle ausgegeben wird

int setzeEiner = digitAnzeige[digitPos] + seg7[einer];      // Initialisierung Anzeige digit0 mit Zahl 0

void displayAusgabe(void) {
  display=setzeEiner;
  HAL_Delay(DIGIT_AN);
  
  }
int main()
{
// Berechne Anzahl an Schleifendurchgängen für DURATION
int count = DURATION / (DIGIT_AN);
 
 while (true) {
     
  for (int i=0; i<= count; i++) {        
     displayAusgabe();
     }
     
    einer++;                           
   if (einer > 6) {                
        einer=0;
         
        digitPos++;
        if (digitPos>3)
        digitPos=0;}  
       
    setzeEiner = digitAnzeige[digitPos] + seg7[einer];
    
 }
 
}  