#include "mbed.h"

I2C i2c(p28, p27);

PwmOut MotorL_EN(p34);
DigitalOut MotorL_REVERSE(P1_0);
DigitalOut MotorL_FORWARD(P1_1);

PwmOut MotorR_EN(p36);
DigitalOut MotorR_FORWARD(P1_3);
DigitalOut MotorR_REVERSE(P1_4);

BusIn linesensor(P0_14, P0_12, P0_16, P0_13);

const int addr = 0x40;          // I2C-Adresse des PCA9555
char cmd[3];


char WertLesen();
void TasterVorneRechts();
void TasterVorneMitte();
void TasterVorneLinks();
void TasterHinten();

int main() {
    
    char btn = 0;
    
    
/*** I2C Konfigurationen ***/
    i2c.frequency(40000);    
    cmd[0] = 0x06;           
    cmd[1] = 0x00;           
    i2c.write(addr, cmd, 2);                                 
    cmd[0] = 0x02;  
        
        
    while(1)
    {     
            MotorR_FORWARD = MotorL_FORWARD = 1; 
            MotorR_EN = MotorL_EN = 1; 
            cmd[1] = 0xFA;           
            i2c.write(addr, cmd, 2);
        
            btn = WertLesen();
        
            if(btn == 128)
                TasterVorneRechts();
        
            if(btn == 4 || btn == 1 || btn == 8)
                TasterVorneMitte();
        
            if(btn == 64)
                TasterVorneLinks();
            
            if(btn == 16 || btn == 2 || btn == 32)
                TasterHinten();
        
            wait(0.1);
            MotorR_EN = MotorL_EN = 0; 
            MotorR_FORWARD = MotorL_FORWARD = 0; 
    } 
}



char WertLesen() {
    char btn;
    i2c.start();
        i2c.write(0x40);    
        i2c.write(0x01);              
    i2c.start();
        i2c.write(0x41);     
        btn = i2c.read(0);  
    i2c.stop(); 
    return btn;
} 


void TasterHinten() {
    
    MotorR_FORWARD = MotorL_FORWARD = MotorL_REVERSE = MotorR_REVERSE = 0;
    MotorR_FORWARD = MotorL_FORWARD = 1; 
    MotorR_EN = MotorL_EN = 0.5f;
    wait(1);
    MotorR_FORWARD = MotorL_FORWARD = 0;
}   


void TasterVorneRechts() {
    int i = 0;
    
    MotorR_FORWARD = MotorL_FORWARD = 0; 
    MotorL_REVERSE = 1;
    MotorL_EN = 0.5f;
    do{
        cmd[1] = 0x77;
        i2c.write(addr, cmd, 2);
        wait(0.07);     
        cmd[1] = 0xFF;
        i2c.write(addr, cmd, 2);
        wait(0.07);
        i++;
    }while(i < 7);

    MotorL_REVERSE = 0;
    MotorL_EN = 0;
}


void TasterVorneMitte() {
    int i =0;
    
    MotorR_FORWARD = MotorL_FORWARD = 0; 
    MotorL_REVERSE = MotorR_REVERSE = 1; 
    MotorL_EN = MotorR_EN = 0.5f;
    cmd[1] = 0xAF;           
    i2c.write(addr, cmd, 2);
    wait(1);
    MotorL_REVERSE = MotorR_REVERSE = 0;
    MotorL_REVERSE = MotorR_FORWARD = 1;
    do {
        cmd[1] = 0x00;
        i2c.write(addr, cmd, 2);
        wait(0.07);
        
        cmd[1] = 0xFF;
        i2c.write(addr, cmd, 2);
        wait(0.07);
        
        i++;
        }while(i < 4);
    MotorL_REVERSE = MotorR_FORWARD = 0;
    MotorL_EN = MotorR_EN = 0;
}


void TasterVorneLinks() {
    int i =0;
    
    MotorR_FORWARD = MotorL_FORWARD = 0; 
    MotorR_REVERSE = 1;
    MotorR_EN = 0.5f;
    do {
        cmd[1] = 0xDD;
        i2c.write(addr, cmd, 2);
        wait(0.07);
        
        cmd[1] = 0xFF;
        i2c.write(addr, cmd, 2);
        wait(0.07);
        
        i++;
        }while(i < 7);
    MotorR_REVERSE = 0;
    MotorR_EN = 0;    
}