
/**
Strommessung gibt Sterne in der Konsole aus. Eins Stern 1/15 der Source Spannung.
*/

#include "mbed.h"

AnalogIn input(A0);
Serial pc(SERIAL_TX, SERIAL_RX); 


int main() { 

uint16_t inputWert = 0x0000;  // inputWert hält Messwerte


while (1) {

inputWert = input.read_u16(); // Werte einlesen.
//pc.printf("sample value: 0x%04X\n",inputWert);
wait_ms(10); 

char text[19] = "<"; // String für die Ausagbe
uint16_t x = 0x0000; // Vergleichswert 
int i = 1;          // Schleifenzähler
if(inputWert <= 0xEEEE){  // wenn gemessene Spannung größer als 0xEEEE wird schleife nicht ausgeführt.
  while(i<16){            // es werden max. 15 Sterne gedruckt, also max 15 durchläufe.
    if (x <= inputWert){ // wenn vergleichswert kleiner 0, dann wird ein stern gedruckt/hinzugefügt.
        text[i] = '*';   
    }else{
        text[i] = ' ';  // wenn vergleichswert > 0, dann wird kein Stern gedruckt, sondern Leertaste.
        }     
   x = x + 0x1111; // Vergleichswert wird erhöht, um 1/15 der Einggansspanung, das heißt, Ein Stern entspricht 1/15 der Eingangspannung.   
   i++;}}
     
     
strcat(text,">");
if(inputWert >= 0xEEEE){ // Wenn Messung größergleich (14/15)* Eingangsspannung
pc.printf("<***************>\n",text);}
else{
pc.printf("%s\n",text);}

}

}
