#ifndef __CURRENT_CONTROL_H__
#define __CURRENT_CONTROL_H__

#include "mbed.h"
#include "PID.h"



class LPF
{public:
    float output, outputLast;
    
    LPF(float samplingTime);
    float filter(float input, float cutOff);
    
private:
    float Ts;    
};


class CURRENT_CONTROL
{
public:
    typedef enum {
        PWM1,
        PWM2
    } PWMIndex;

    CURRENT_CONTROL(PinName curChannel, PinName PwmChannel1, PinName PwmChannel2, PWMIndex pwmIndex, float Kp, float Ki, float Kd, float samplingTime);
    float saturation(float input, float limit_H, float limit_L);
    void Control(float curRef, float speed);
    void SetParams(float Analog2Cur, float angSpeed2Backemf, float voltage2DutyRatio);
    
    //functions for test////////
    void ChangePwmPeriod(float microSeconds);
    void SetPWMDuty(float ratio);
    float GetAnalogIn(void);
    float GetCurrent(void);
    //////////////////////////
    PWMIndex pwmIndex_;
    PID pid;
    PwmOut MotorPlus;
    PwmOut MotorMinus;
    float controlOutput;

    float currentOffset;
    float curFeedBack;
    
    AnalogIn currentAnalogIn;
    float analogInValue;
    
    float analog2Cur;
    float Kw;
    float voltage2Duty;
    LPF lpFilter;
    
    
private:

    float Ts;
    

};

































#endif