#include "mbed.h"
/*
    Gael board NUCLEO-F401RE SPI slave
*/
 
 //------------------------------------
// Serial configuration (Put on hyperterminal or Putty)
// 115200 bauds, 8-bit data, no parity
//------------------------------------
Serial serialIO(SERIAL_TX, SERIAL_RX);

int main() {
    
    // Configure the serial speed.
    serialIO.baud(115200);
    serialIO.printf("SPI Slave example with mbed!\r\n");
    
    // Configure the SPI to 8-bits Mode 0, 5Mhz    
    SPISlave spiSlave(PA_7, PA_6, PA_5, PA_15); // mosi, miso, sclk, ssel
    spiSlave.format(8,0);    
    spiSlave.frequency(5000000);
    spiSlave.reply(191);   
    
    serialIO.printf("SPI Slave Waiting!\r\n");                                         
    while(1) {                
        wait_us(2);                
        if(spiSlave.receive())
        {            
            serialIO.printf("Slave received: %d\r\n",spiSlave.read());
        }
    }
}
 