#include "mbed.h"
/*
    SPI Master used to test the FPGA slave
    https://developer.mbed.org/media/uploads/robt/mbed_course_notes_-_serial_spi.pdf
*/

Serial serialIO(SERIAL_TX, SERIAL_RX);
int main() {
    
    // Configure the serial speed.
    serialIO.baud(115200);
    serialIO.printf("SPI Master example with mbed!\r\n");
    
    // Configure the SPI to 8-bits Mode 0, 5Mhz
    // Create a SPI master
    SPI spiMaster(PA_7, PA_6, PA_5); // mosi, miso, sclk
    DigitalOut chipSelect(PB_6);
    spiMaster.format(8,0);    
    int frequency;
    serialIO.printf("Choose SPI freq:\r\n");
    serialIO.scanf("%d",&frequency);
    serialIO.printf("Setting frequency: %d\r\n",frequency);
    spiMaster.frequency(frequency); //5000000
    chipSelect = 1;    
    int mode = 0;
    int byteToSend = 0;
    int countPackages = 3;
    int foreverMode = 0;
                
    while(1) {        
        if ((!byteToSend) || (countPackages == 0))
        {
            serialIO.printf("Type the mode:\r\n");
            serialIO.scanf("%d",&mode);
            spiMaster.format(8,mode);            
            serialIO.printf("Type the byte value to send, then press ENTER\r\n");
            serialIO.scanf("%d",&byteToSend);        
            serialIO.printf("Number of times to send, then press ENTER (-1) is forever\r\n");
            serialIO.scanf("%d",&countPackages);    
            if (countPackages < 0)     
            {    
                foreverMode = 1;
                serialIO.printf("Sending %d packages on mode %d with freq: %d (FOREVER)\r\n",countPackages,mode,frequency);
            }
            else                
                serialIO.printf("Sending %d packages on mode %d with freq: %d\r\n",countPackages,mode,frequency);
                                
        }
        chipSelect = 0;        
        int resp = spiMaster.write(byteToSend);                
        chipSelect = 1;        
        wait_us(2);
        if (!foreverMode)
        {
            serialIO.printf("Sending data<%d> received<%d> %d times\r\n",byteToSend, resp, countPackages);
            byteToSend++;
        } 
        else
        {
            serialIO.printf("Sending data<%d> received<%d> %d times at freq:%d\r\n",byteToSend, resp, countPackages,frequency);
        }
        countPackages--;        
    }
}
 