#ifndef I_BUTTON_H
#define I_BUTTON_H

#include "mbed.h"
#include <string>
#include <vector>

//typedef struct
//{
//    unsigned char family;
//    unsigned char serial[6];
//    unsigned char crc;
//    unsigned char valid;
//} ibuttonvalue;
class ibuttonvalue
{
public:
    unsigned char family;
    std::vector<unsigned char> serial;
    unsigned char crc;
    bool valid;
};

class iButton
{
public:
    
    iButton(PinName IO);
    ~iButton();
    
    void OneWireReset(void);
    void OneWireOutByte(unsigned char data);
    unsigned char OneWireReadByte(void);
    void DetectiButton(void);
    std::string GetData(void);
    bool IsTaping(void);
    
private:
    DigitalInOut io;    
    ibuttonvalue detect;
    unsigned char CrcTemp;
    
    unsigned char crc8(unsigned char crc, unsigned char data);
    void ResetData();
    
};

#endif // I_BUTTON_H
