#ifndef TM220U_H
#define TM220U_H

//#include "mbed.h"
#if defined(__CC_ARM)
// To avoid "invalid multibyte character sequence" warning
#pragma diag_suppress 870
#endif

#define DefaultDotSpacing 24
#define MaxLineSpacing 10

class TMU220 : public Stream
{
public :
    enum line_mode{single_line=1, double_line, triple_line};

    TMU220(PinName tx_, PinName rx_, uint32_t baud_=9600);
    TMU220(Serial &serial_obj, uint32_t baud_=9600);
    virtual ~TMU220();
    
    void initialize(void);
    void printModes(uint8_t n=1);
    void selectFontMode(bool imbang);
    void printTest(void);
    void lineFeed(void);
    void carriageReturn(void);
    void putLineFeed(uint8_t lines);
    void printnputLineFeed(uint8_t lines);
    void setDefaultLineSpacing();
    void setLinespacing(uint8_t lines=24);
//    void setLinespacing(line_mode mode);
    void papersensorstatus(void);
    void putHorizontaltab(void);
    void putPaperFeed(uint8_t space);
    void setInterCharacterSpace(uint8_t space);
    void defaultInterCharacterSpace();
    void cutPaper();
    void feednCut(uint8_t lines = 1);
    void clearQuadrupleSize();
    void setQuadrupleSize();
    void setEnlargement(uint32_t width, uint32_t height);
    void clearEnlargement();
    
private :
    Serial *Com_p;
    Serial &Com;
    
protected:
    // Stream implementation functions
    virtual int _putc(int value);
    virtual int _getc();
};

#endif //TM220U_H
