#include "mbed.h"
#include "TMU220.h"

TMU220::TMU220(PinName tx_, PinName rx_, uint32_t baud_)
    :
    Com_p(new Serial(tx_, rx_)),
    Com(*Com_p)
{
    Com.baud(baud_);
//    initialize();
}
 
TMU220::TMU220(Serial &serial_obj, uint32_t baud_)
    :
    Com_p(NULL),
    Com(serial_obj)
{
    Com.baud(baud_);
//    initialize();
}
 
TMU220::~TMU220()
{
}

void TMU220::initialize(void)
{
    Com.putc(0x1B);
    Com.putc(0x40);
}

void TMU220::printModes(uint8_t n)     
{
    Com.putc(0x1B);
    Com.putc(0x21);
    Com.putc(n);
    
//Possible values for n    
//00 = 32 Char Normal                                        08 = 32 Char BOLD
//01 = 24 Char Normal                                        09 = 24 Char BOLD
//11 = 24 Char Double Height                                 19 = 24 Char Double Height & BOLD
//21 = 24 Char Double Width                                  29 = 24 Char Double Width & BOLD
//31 = 24 Char Double Height & Double Width                  39 = 24 Char Double Height & Double Width & BOLD
//10 = 32 Char Double Height                                 18 = 32 Char Double Height & BOLD
//20 = 32 Char Double Width                                  28 = 32 Char Double Width & BOLD
//30 = 32 Char Double Height & Double Width                  38 = 32 Char Double Height & Double Width & BOLD
    
}

void TMU220::selectFontMode(bool imbang)
{
    Com.putc(0x1B);
    Com.putc(0x4D);
    Com.putc((int)imbang);
}

void TMU220::printTest(void)
{
    Com.putc(0x1D);
    Com.putc(0x28);
    Com.putc(0x41);
    Com.putc(0x02);
    Com.putc(0x00);
    Com.putc(0x00);
    Com.putc(0x03);
}
 
void TMU220::lineFeed(void)
{
    Com.putc(0x0A);
}
 
 
void TMU220::carriageReturn(void)
{
    Com.putc(0x0D);
}

void TMU220::putLineFeed(uint8_t lines)
{
    for(uint32_t i = 0; i < lines; i++)
    {
        lineFeed();
    }
}
 
void TMU220::printnputLineFeed(uint8_t lines)
{
    Com.putc(0x1B);
    Com.putc(0x64);
    Com.putc(lines);
}
 
void TMU220::setDefaultLineSpacing(void)
{
    Com.putc(0x1B);
    Com.putc(0x32);
}
  
void TMU220::setLinespacing(uint8_t lines)
{
    uint8_t val;
    uint8_t n;
    
    lines > 255? n = 255 : n = lines;
    
    val = DefaultDotSpacing * n;
    
    Com.putc(0x1B);
    Com.putc(0x33);
    Com.putc(val);
}

void TMU220::setQuadrupleSize()
{
    Com.putc(0x1C);
    Com.putc(0x57);
    Com.putc(0x31);
}
 
void TMU220::clearQuadrupleSize()
{
    Com.putc(0x1C);
    Com.putc(0x57);
    Com.putc(0x30);
}

void TMU220::setEnlargement(uint32_t width, uint32_t height)
{
    Com.putc(0x1C);
    Com.putc(0x65);
    Com.putc(width);
    Com.putc(height);
}
 
void TMU220::clearEnlargement()
{
    Com.putc(0x1C);
    Com.putc(0x65);
    Com.putc(0x01);
    Com.putc(0x01);
}
 
void TMU220::papersensorstatus(void)
{
    Com.putc(0x1B);
    Com.putc(0x76);
    
    // Poll Rx pin of printer Here
    //0x00 Paper Present
    //0x20 Paper Absent
}

void TMU220::putHorizontaltab(void)
{
    Com.putc(0x09);
}
 
void TMU220::putPaperFeed(uint8_t space)
{
    Com.putc(0x1B);
    Com.putc(0x4A);
    Com.putc(space);
}
 
void TMU220::setInterCharacterSpace(uint8_t space)
{
    Com.putc(0x1B);
    Com.putc(0x20);
    Com.putc(space);
}
 
void TMU220::defaultInterCharacterSpace()
{
    Com.putc(0x1B);
    Com.putc(0x20);
    Com.putc(0x00);
}

void TMU220::cutPaper()
{
    Com.putc(0x1D);
    Com.putc(0x56);
    Com.putc(0x31);
}

void TMU220::feednCut(uint8_t lines)
{
    Com.putc(0x1D);
    Com.putc(0x56);
    Com.putc(65);
    Com.putc(lines);
}
 
int TMU220::_putc(int value)
{
    Com.putc(value);
    return value;
}
 
int TMU220::_getc()
{
    return -1;
}
