/*******************************************************************************
    * Project   : Printer SPBU
    * Version   : 4.2
    * Board     : D:\1.PROJECT\02. Pertamina (Depot)\5. SPBU Dispenser\Board\ver 3\Printer_SPBU_Fusion_v3.pdf
    * Descriptio: Update dari 4.1

*******************************************************************************/
#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "const_defines.h"
#include "Printer.h"
#include "keypad.h"
#include "TextLCD.h"
#include "Audio.h"
#include <fstream>
#include <sstream>
#include <vector>
#include <queue>

#define interval 500
//#define PortListen 50004
//#define PortSend 50001
/*******************************************************************************
    Pin Init
*******************************************************************************/
Serial dbg(USBTX, USBRX); // Serial to PC
//Serial sock(D1,D0); ; // Modbus Line
Printer Dm(p13, p14, 9600); // Serial to printer
DigitalOut led(LED1), hb(p25);
DigitalOut rede(p11, 0);
Audio buzz(p26);
Keypad key(p17, p18, p15, p16, p21, p22, p19, p20);
//Keypad key(p22, p19, p15, p16, p21 , p20, p18, p17);
I2C i2c_lcd(p28,p27); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, PCF8574_SA7, TextLCD::LCD16x4);
//DigitalIn sw2(SW2);
//DigitalIn sw3(SW3);

/*******************************************************************************
    Variable Init
*******************************************************************************/
//UDPSocketConnection socket;
UDPSocket socket;
Endpoint multi, server;
LocalFileSystem local("local");

char tData[64], rData[64];
string IP, SM, GW, MCAST;
int PortListen, PortSend;
//const char* SERVER_ADDRESS = "192.168.4.155"; // gerem
//const int SERVER_PORT = 6000;
//
//const char* IP = "192.168.4.17";
//const char* SM = "255.255.255.0";
//const char* GW = "192.168.4.239";

/******************************************************************************/
//const char* SERVER_ADDRESS = "172.20.1.28"; // TBN
//const int SERVER_PORT = 6000;

//const char* IP = "172.20.1.212";
//const char* SM = "255.255.255.0";
//const char* GW = "172.20.1.1";
/******************************************************************************/
uint8_t selang;
unsigned int no_nota=0;
uint8_t nozz=0;
uint8_t pipa=0;
uint8_t KlikIndex;
uint8_t MaxIndex;

// Keypad Variable -------------------------------------------------------------
uint8_t cursorx = 0; //cursor x position
uint8_t cursory = 0; //cursor y position
uint8_t startcursorx = 0; //cursor x position
uint8_t startcursory = 0; //cursor y position
char typedtext[64];
int positionintypedtext=0;

uint32_t KeyIndex;
bool tekan;
uint32_t cbAfterInput(uint32_t index); // Callback Function

//char Keytable1[] = { 'D', 'C', 'B', 'N',   // r0
//                     'M', '9', '6', '3',   // r1
//                     '0', '8', '5', '2',   // r2
//                     'Y', '7', '4', '1'    // r3
//                   };

char Keytable1[] = { '1', '3', '2', 'A',   // r0
                     '4', '6', '5', 'B',   // r1
                     'Y', 'M', '0', '8',   // r2
                     '7', '9', '8', 'D'    // r3
                   };

char * CharacterMask[4][4] = {
    { "1", "2ABC", "3DEF", " "},
    { "4GHI", "5JKL", "6MNO", " " },
    { "7PQRS", "8TUV", "9WXYZ", " "},
    { "*", "0", "#", "."}
};
//------------------------------------------------------------------------------

string _nopol[7],_km[7];

struct tm t;
PrinterFormat Pf;
uint8_t step, lastStep;
char pushIt;
unsigned int timer;
unsigned long int bounceSW2=0,bounce=0;
/*******************************************************************************
    Function Init
*******************************************************************************/
Ticker Tick1s;
void tick1s();

int tick1mstick;
Ticker tick1ms;
void Tick1Ms()
{
    tick1mstick++;
}

void show_menu(const int &step_);
void input_nopol();
void input_km();
void setting_rtc();
void init();
std::vector<std::string> split(const std::string str, const std::string separator);
ResultParsing parsing(const char* input, const uint8_t idx);
ResultParsing parsingmanual(const char* input);
string open_file(const char *location);
bool mbed_config_init();
void flush(void);
string Get_Time();

/*******************************************************************************
    Main Function
*******************************************************************************/
int main()
{
    buzz.mute();
    PortListen = 50001;
    PortSend = 50001;
    dbg.baud(9600);
    dbg.printf("<PROGRAM START>\r\n");

    mbed_config_init();

    EthernetInterface eth;
    eth.init(IP.c_str(), SM.c_str(), GW.c_str()); //Use DHCP
    int n = eth.connect();
    dbg.printf("Eth Status = %d\r\n",n);
    if(n == 0)INFO("Connected with IP : %s\r\n", IP.c_str());
    else ERROR("Not Connected with IP : %s\r\n", IP.c_str());

    socket.bind(PortListen);
    socket.set_blocking(false, 0);
    server.set_address(MCAST.c_str(), PortSend);
    sprintf(tData,"DevReset");
    multi.set_address(MCAST.c_str(), PortSend);
    socket.sendTo(multi, tData, strlen(tData));

    key.CallAfterInput(&cbAfterInput);
    key.Start();  // energize the keypad via c0-c3

//    rtc.check_alarm();
//    rtc.Initialize(PCF8523::CTRL3, 0x01);

    wait_ms(1000);
    Dm.init(Pf);
    wait_ms(1000);

    Dm.TestPrint2();
    Dm.create_header();

    init();

    step = 0;
    lastStep = step;
    pushIt = 0;
    KeyIndex = 20;
    MaxIndex = Pf.first_nozle + Pf.JumlahFillingPoint;
    KlikIndex = 0;

    Tick1s.attach(&tick1s, 1.0f);
    tick1ms.attach_us(&Tick1Ms, 1000);

    for(int i=0; i<7; i++) {
        _nopol[i].clear();
        _km[i].clear();
    }
    show_menu(step);
    char sndrcv = 0;

    dbg.printf("Ready...\r\n");
    
    while (true) {

//        wait_ms(100);
//        string now;
//        now = Get_Time();
//        dbg.printf("%s\r\n",now);

       // wait(1);
//        time_t time_now;
//        
//        time_now = time(NULL);
//        dbg.printf("%s\r\n",ctime(&time_now));
        
        if(lastStep != step) {
            dbg.printf("Goes to step %d\r\n", step);
            lastStep = step;
            lcd.cls();
            show_menu(step);
        }
        
        
        switch(step) {
            case 0:
                if(sndrcv == 0) {
                    if(tekan) {
                        tekan = false;
                        pushIt = Keytable1[KeyIndex];
                        if(pushIt == 'M') {
                            step = 1;
                        } else if((pushIt >= '1') && (pushIt <= '9')) {
                            KlikIndex = Pf.first_nozle + ((pushIt-0x30)-1);

                            if((KlikIndex > 0) && (KlikIndex < MaxIndex)) {
                                flush();
                                memset(tData,0,sizeof(tData));
                                sprintf(tData,"Nozle:%d", KlikIndex);
                                INFO("Send:\r\n%s\r\n to: %s:%d\r\n", tData,MCAST.c_str(),PortSend);
                                multi.set_address(MCAST.c_str(), PortSend);
                                socket.sendTo(multi, tData, strlen(tData));
                                tick1mstick = 0;
                                sndrcv = 1;
                            }
                        }
                    } else {
                        socket.bind(PortListen);
                        int n = socket.receiveFrom(server, rData, sizeof(rData));
                        if (n != 0) {
                            FLOW("Packet from \"%s:%d\"\r\n %s\n\r", server.get_address(), server.get_port(), rData);
                            ResultParsing res = parsingmanual(rData);

                            if(res.valid) {
                                INFO("Data Valid! print...\r\n");
                                time_t t = time(NULL);
                                no_nota++;
                                Dm.PrintStrukManual(t, res, no_nota);
                                //Dm.DebugStruk(t, res, no_nota);
                                sndrcv = 0;
                                show_menu(0);
                                pushIt = 0;
                                KlikIndex = 0;
                            } else {
                                ERROR("Data not Valid! Reset!!\r\n");
                                _nopol[pushIt-0x31].clear();
                                _km[pushIt-0x31].clear();
                                sndrcv = 0;
                                show_menu(0);
                                pushIt = 0;
                                KlikIndex = 0;
                            }
                            memset(rData, 0, sizeof(rData));
                        }
                    }
                } else if(sndrcv == 1) { // receive data after user push keypad
                    socket.bind(PortListen);
                    int n = socket.receiveFrom(server, rData, sizeof(rData));
                    if (n != 0) {
                        FLOW("Packet from \"%s:%d\"\r\n %s\n\r", server.get_address(), server.get_port(), rData);
                        ResultParsing res = parsing(rData, KlikIndex);

                        if(res.valid) {
                            INFO("Data Valid! print...\r\n");
                            time_t t = time(NULL);
                            no_nota++;
                            Dm.PrintStruk(t, res, no_nota, _nopol[pushIt-0x31], _km[pushIt-0x31]);
                            Dm.DebugStruk(t, res, no_nota, _nopol[pushIt-0x31], _km[pushIt-0x31]);
                            _nopol[pushIt-0x31].clear();
                            _km[pushIt-0x31].clear();
                            sndrcv = 0;
                            show_menu(0);
                            pushIt = 0;
                            KlikIndex = 0;
                        } else {
                            ERROR("Data not Valid! Reset!!\r\n");
                            _nopol[pushIt-0x31].clear();
                            _km[pushIt-0x31].clear();
                            sndrcv = 0;
                            show_menu(0);
                            pushIt = 0;
                            KlikIndex = 0;
                        }
                        memset(rData, 0, sizeof(rData));
                    }

                    if(tick1mstick > 10000) {
                        ERROR("TIMEOUT!!!\r\n");
                        tick1mstick = 0;
                        sndrcv = 0;
                        show_menu(0);
                        pushIt = 0;
                        KlikIndex = 0;
                    }
                }
                break;

            case 1:
                if(tekan) {
                    tekan = false;
                    pushIt = Keytable1[KeyIndex];
                    dbg.printf("Tekan : %c\r\n", pushIt);
                    if(pushIt == 'M') {
                        step = 0;
                    } else if(pushIt == '1') {
                        step = 2;
                    } else if(pushIt == '2') {
                        step = 3;
                    }
                    pushIt = 0;
                }
                break;

            case 2:
                input_nopol();
                step = 0;
                break;

            case 3:
                setting_rtc();
                step = 0;
                break;

        } // switch step
        delay(10);
    }
}

/*******************************************************************************
    Other Function
*******************************************************************************/
void tick1s()
{
    led = !led;
    hb = !hb;
}

std::vector<std::string> split(const std::string str, const std::string separator)
{
    char *cstr = const_cast<char*>(str.c_str());
    char *current;

    std::vector<std::string>arr;
    current = strtok(cstr, separator.c_str());
    while(current != NULL) {
        arr.push_back(current);
        current = strtok(NULL, separator.c_str());
    }
    return arr;
}

ResultParsing parsing(const char* input, const uint8_t idx)
{
    /***********************************************
     *  20;1.940000;15132.000000;7800.000000;1;1;  *
     *  Pump ID:Volume:Money:PPU:Price Level:Type: *
     ***********************************************/

    ResultParsing res;
    vector<string> pars = split(input, ";");

    TEST("idx : %d\r\n", idx);
    for(int i=0; i< pars.size(); i++) {
        FLOW("%d. %s\r\n", i, pars[i]. c_str());
    }
    FLOW("\r\n");

    if((pars.size()>=5) && (idx == atoi(pars[0].c_str()))) {
        res.valid = true;
        res.id = atoi(pars[0].c_str());
        res.volume = atof(pars[1].c_str());
        res.money = atoi(pars[2].c_str());
        res.ppu = atoi(pars[3].c_str());
        res.product = Pf.prodak[atoi(pars[5].c_str())- 1];
        res.type = atoi(pars[4].c_str());
    } else {
        res.valid = false;
        res.id = 0;
        res.volume = 0;
        res.money = 0;
        res.ppu = 0;
        res.product = "\0";
        res.type = 0;
    }
    return res;
}

ResultParsing parsingmanual(const char* input)
{
    /***********************************************
     *  20;1.940000;15132.000000;7800.000000;1;1;  *
     *  Pump ID:Volume:Money:PPU:Price Level:Type: *
     ***********************************************/

    ResultParsing res;
    vector<string> pars = split(input, ";");
    vector<string> id_manual = split(pars[0], "#");
    int idx = atoi(id_manual[1].c_str());
    TEST("idx : %d\r\n", idx);
    for(int i=0; i< pars.size(); i++) {
        FLOW("%d. %s\r\n", i, pars[i]. c_str());
    }
    FLOW("\r\n");

    if(pars.size()>=5) {
        res.valid = true;
        res.id = idx;
        res.volume = atof(pars[1].c_str());
        res.money = atoi(pars[2].c_str());
        res.ppu = atoi(pars[3].c_str());
        res.product = Pf.prodak[atoi(pars[5].c_str())- 1];
        res.type = atoi(pars[4].c_str());
    } else {
        res.valid = false;
        res.id = 0;
        res.volume = 0;
        res.money = 0;
        res.ppu = 0;
        res.product = "\0";
        res.type = 0;
    }
    return res;
}

void flush(void)
{
    int chk;
    do {
        char flush_buff[1024] = { 0 };
        socket.bind(PortListen);
        chk = socket.receiveFrom(server, flush_buff, sizeof(flush_buff));
        //clear flush_buff
        for(int i = 0; i <sizeof(flush_buff); i++) {
            flush_buff[i] = '\0';
        }
    } while (chk > 0);
}

string open_file(const char *location)
{
    string rtn = "\0";

    dbg.printf("OPEN FILE %s\r\n", location);
    ifstream stream(location, std::ifstream::binary);

    if ( !stream.is_open() ) {
        dbg.printf("File Opening Error\n\r");
        stream.close();
    } else {
        stream.seekg(0,stream.end);
        int len = stream.tellg();
        stream.seekg(0,stream.beg);

        char *_stream = new char [len];

        stream.read(_stream,len);
        _stream[len] = '\0';

        rtn += _stream;
        stream.close();
        delete [] _stream;
    }

    return rtn;
}

bool mbed_config_init()
{
    dbg.printf("Masuk mbed config init\r\n");
    string dataSet = open_file("/local/CONFIG.TXT");
    //dbg.printf("isi file :\r\n%s\r\n", dataSet.c_str());

    if(dataSet.size() > 1) {

        vector<string> data_config = split(dataSet, "\n");


        for(int i = 0; i<sizeof(data_config); i++) {

            vector<string> data_config_temp;
            data_config_temp = split(data_config[i], ":");

            if(data_config_temp[0] == "id") {
                Pf.id = atoi(data_config_temp[1].c_str());
                dbg.printf("%s = %d\r\n",data_config_temp[0],Pf.id);
            } else if(data_config_temp[0] == "no_spbu") {
                Pf.spbu = data_config_temp[1];
                dbg.printf("%s = %s\r\n",data_config_temp[0],Pf.spbu);
            } else if(data_config_temp[0] == "addr") {
                Pf.alamat = split(data_config_temp[1], ",");
                for(int a = 0; a<Pf.alamat.size(); a++) {
                    if(Pf.alamat[a] != "\0")
                        dbg.printf("%s = %s\r\n",data_config_temp[0],Pf.alamat[a]);
                }
            } else if(data_config_temp[0] == "telp") {
                Pf.telp = data_config_temp[1];
                dbg.printf("%s = %s\r\n",data_config_temp[0],Pf.telp);
            } else if(data_config_temp[0] == "footer") {
                Pf.footer = split(data_config_temp[1], ",");
                for(int a = 0; a<Pf.footer.size(); a++) {
                    if(Pf.footer[a] != "\0")
                        dbg.printf("%s = %s\r\n",data_config_temp[0],Pf.footer[a]);
                }
            } else if(data_config_temp[0] == "first") {
                Pf.first_nozle = atoi(data_config_temp[1].c_str());
                dbg.printf("%s = %d\r\n",data_config_temp[0],Pf.first_nozle);
            } else if(data_config_temp[0] == "jml") {
                Pf.JumlahFillingPoint = atoi(data_config_temp[1].c_str());
                dbg.printf("%s = %d\r\n",data_config_temp[0],Pf.JumlahFillingPoint);
            } else if(data_config_temp[0] == "produk") {
                Pf.prodak = split(data_config_temp[1], ",");
                for(int a = 0; a<Pf.prodak.size(); a++) {
                    if(Pf.prodak[a] != "\0")
                        dbg.printf("%s = %s\r\n",data_config_temp[0],Pf.prodak[a]);
                }
            } else if(data_config_temp[0] == "IP") {
                IP = data_config_temp[1];
                dbg.printf("%s = %s\r\n",data_config_temp[0],IP);
            } else if(data_config_temp[0] == "SM") {
                SM = data_config_temp[1];
                dbg.printf("%s = %s\r\n",data_config_temp[0],SM);
            } else if(data_config_temp[0] == "MCAST") {
                MCAST = data_config_temp[1];
                dbg.printf("%s = %s\r\n",data_config_temp[0],MCAST);
            }
        }

        dbg.printf("Config is Sucsses\r\n");
        return true;

    } else {
        dbg.printf("Config is not found\r\n");
        return false;
    }
}

void show_menu(const int &step_)
{
    dbg.printf("Show menu %d\r\n", step);
    switch(step_) {
        case 0:
            lcd.setCursor(TextLCD::CurOff_BlkOff);
            lcd.cls();
            lcd.locate(0,0);
            _nopol[0].size()>0?lcd.printf("%s",_nopol[0].c_str()):lcd.printf("-");
            lcd.locate(0,1);
            _nopol[1].size()>0?lcd.printf("%s",_nopol[1].c_str()):lcd.printf("-");
            lcd.locate(0,2);
            _nopol[2].size()>0?lcd.printf("%s",_nopol[2].c_str()):lcd.printf("-");
            lcd.locate(0,3);
            _nopol[3].size()>0?lcd.printf("%s",_nopol[3].c_str()):lcd.printf("-");
            break;

        case 1:
            lcd.setCursor(TextLCD::CurOff_BlkOff);
            lcd.locate(0,0);
            lcd.printf("1.Nopol & Odo");
            lcd.locate(0,1);
            lcd.printf("2.Setting RTC");
            break;

        case 2:
            lcd.setCursor(TextLCD::CurOn_BlkOff);
            lcd.locate(0,0);
            lcd.printf("Nopol:");
            lcd.locate(0,1);
            lcd.printf("Odo  :");
            lcd.locate(0,2);
            lcd.printf("Nozle:");
            break;

        case 3:
            lcd.cls();
            lcd.setCursor(TextLCD::CurOn_BlkOff);
            lcd.locate(0,0);
            lcd.printf("Date:");
            lcd.locate(0,1);
            lcd.printf("Time:");
            break;
    }
}

void dospace()   //moves cursor forward once, wraps to next line if necessary, clears and returns to top of display if at bottom
{
    if(positionintypedtext<10) {
        cursorx++; //increment the cursor to the right
        lcd.locate(cursorx,cursory); //set cursor to defined location
    }
}

void doreset()
{
    //clears and returns to top-left of display
    memset(typedtext, 0, sizeof(typedtext));
    positionintypedtext = 0;
    cursorx = startcursorx;
    cursory = startcursory;
}

void dobackspace()
{
    //does a backspace, essentially the opposite of dospace
    if (cursorx==startcursorx) {
        if(positionintypedtext>8) {
            cursorx=15;
            cursory=startcursory;
        } else {
            cursorx=startcursorx;
            cursory=startcursory;
        }
    } else {
        cursorx--;
    }
    lcd.locate(cursorx,cursory);
    if(positionintypedtext<10)lcd.putc(' ');
    else lcd.putc(typedtext[cursorx-6]);
    lcd.locate(cursorx,cursory);
    dbg.printf("x: %d, y:%d\r\n", cursorx,cursory);
}

void textstorage(uint8_t mode, char keyData=0)
{
    if (mode==1) {
        //regular character storage
        typedtext[positionintypedtext]=keyData; //store letter that was printed to LCD in typedtext
        positionintypedtext++; //increment position in typedtext
        if(positionintypedtext>9)positionintypedtext=9;
    }
    if (mode==2) {
        //do a space in stored text
        typedtext[positionintypedtext]=' '; //set current position in typedtext to a space
        positionintypedtext++; //increment position in typedtext
        if(positionintypedtext>9)positionintypedtext=9;
    }
    if (mode==3) {
        //does a backspace in the stored text
        positionintypedtext--; //decrement position in typedtext
        if(positionintypedtext<0)positionintypedtext=0;
        typedtext[positionintypedtext]=0; //set current position in typedtext to a space
    }
    //dbg.printf("positionintypedtext: %d\r\n", positionintypedtext);
}

string get_alphanumeric(const uint8_t &awalx, const uint8_t &awaly)
{
    string res;

    bool stop = false;
    char customKey=0, lastKey=0;
    int K_count;
    char Character;
    bool lockout = true;
    cursorx = awalx;
    cursory = awaly;
    startcursorx = awalx;
    startcursory = awaly;
    lcd.locate(cursorx, cursory);

    while(stop == false) {

        if(tekan) {
            tekan = false;
            customKey = Keytable1[KeyIndex];

            //Check the key pressed. If the key is different, show it on a new line
            if (customKey && customKey != lastKey) {
                lastKey = customKey; // update lastKey
                K_count = 0; // This resets the counter so when a different key is pressed, you only see the NUMBER associated with that key.
                tick1mstick = 0;
                lockout = true;
            }

            if (customKey) {
                tick1mstick=0; // start a timer, when a key is pressed
                lockout = false; // allow the lockout timer to be checked
                lastKey = customKey; // update lastKey

                switch (customKey) {
                    case '1':
                        Character = *CharacterMask[0][0];                                                              // Character = '1'
                        break;

                    case '2':
                    case '3':
                        Character = *(CharacterMask[0][(customKey - '0') - 1] + K_count);                              // Character = '2' - ABC and '3' - DEF
                        K_count++;
                        if (K_count >= (uint8_t)(strlen(CharacterMask[0][(customKey - '0') - 1])))
                            K_count = 0;                                                                                 // Update the counter if the same key is pressed (counter rolls over)
                        break;

                    case '4':
                    case '5':
                    case '6':
                        Character = *(CharacterMask[1][(customKey - '0') - 4] + K_count);
                        K_count++;
                        if (K_count >= (uint8_t)(strlen(CharacterMask[1][(customKey - '0') - 4])))
                            K_count = 0;
                        break;

                    case '7':
                    case '8':
                    case '9':
                        Character = *(CharacterMask[2][(customKey - '0') - 7] + K_count);
                        K_count++;
                        if (K_count >= (uint8_t)(strlen(CharacterMask[2][(customKey - '0') - 7])))
                            K_count = 0;
                        break;

                    case '0':
                        Character = *CharacterMask[3][1]; // shows 0
                        break;

                    case 'Y':
                        res.clear();
                        if(positionintypedtext > 0) {
                            res += typedtext;
                        }
                        doreset();
                        Character = 0;
                        stop = true;
                        break;

                    case 'N':
                        res.clear();
                        doreset();
                        Character = 0;
                        stop = true;
                        goto failure;
                        break;

                    case 'M':
                        Character = 0;
                        textstorage(3);
                        dobackspace();
                        break;

                    case 'C':
                        Character = *CharacterMask[1][3];
                        break;

                    case 'D':
                        Character = 0;
//                        doreset();
//                        show_menu(2);
                        break;

                    default: // if something unexpected happens, set Character to 0
                        Character = 0;
                        break;
                }
                dbg.printf("Costum key : %c || Char %c || K_Count %d\r\n", customKey, Character, K_count);
                if(Character) {
                    lcd.putc(Character);
                    lcd.locate(cursorx,cursory);
                }
            }
        }

        if((tick1mstick >= interval) && !lockout) {
            lockout = true; // lockout is set to true, thus this IF statement does not continue to execute
            K_count = 0; // Resets the counter
            tick1mstick = 0;
            dbg.printf("Timeout!!!\r\n");
            if(Character) {
                textstorage(1, Character); //store character
                dospace(); //do a space
            }
            customKey = 0;
        }
        wait_ms(20);
    }
failure:
    return res;
}

string get_numeric(const uint8_t &awalx, const uint8_t &awaly)
{
    string res;

    bool stop = false;
    bool lockout = true;
    char customKey=0, lastKey=0;
    int K_count;
    char Character;
    cursorx = awalx;
    cursory = awaly;
    lcd.locate(cursorx, cursory);
    startcursorx = awalx;
    startcursory = awaly;

    while(stop == false) {
        if(tekan) {
            tekan = false;
            customKey = Keytable1[KeyIndex];

            //Check the key pressed. If the key is different, show it on a new line
            if (customKey && customKey != lastKey) {
                lastKey = customKey; // update lastKey
                K_count = 0; // This resets the counter so when a different key is pressed, you only see the NUMBER associated with that key.
                tick1mstick = 0;
//                              New = true;
            }

            if (customKey) {
                tick1mstick=0; // start a timer, when a key is pressed
                lockout = false; // allow the lockout timer to be checked
                lastKey = customKey; // update lastKey

                switch (customKey) {
                    case '1':
                    case '2':
                    case '3':
                    case '4':
                    case '5':
                    case '6':
                    case '7':
                    case '8':
                    case '9':
                    case '0':
                        Character = customKey; // shows 0
                        break;

                    case 'Y':
                        res.clear();
                        if(positionintypedtext > 0) {
                            res += typedtext;
                        }
                        doreset();
                        Character = 0;
                        stop = true;
                        break;

                    case 'N':
                        res.clear();
                        Character = 0;
                        stop = true;
                        goto failure;
                        break;

                    case 'M':
                        Character = 0;
                        dobackspace();
                        textstorage(3);
                        break;

                    case 'C':
                        Character = '.';
                        break;

                    case 'D':
                        Character = '/';
                        break;

                    default: // if something unexpected happens, set Character to 0
                        Character = 0;
                        break;
                }
                dbg.printf("Costum key : %c || Char %c || K_Count %d\r\n", customKey, Character, K_count);
                if(Character) {
                    lcd.putc(Character);
                    lcd.locate(cursorx,cursory);
                }
            }
        }

        if((tick1mstick >= 250) && !lockout) {
            lockout = true; // lockout is set to true, thus this IF statement does not continue to execute
            K_count = 0; // Resets the counter
            tick1mstick = 0;
            dbg.printf("Timeout!!!\r\n");
            if(Character) {
                textstorage(1, Character); //store character
                dospace(); //do a space
            }
            customKey = 0;
        }
        wait_ms(20);
    }
failure:
    return res;
}

void input_nopol()
{
    string nopol_,km_,nozle_;
    nopol_ = get_alphanumeric(6,0);
    km_ = get_numeric(6,1);
    if((nopol_.size()>0) || (km_.size()>0)) {
        nozle_ = get_numeric(6,2);
        if(nozle_.size()>0) {
            int num = atoi(nozle_.c_str())-1;
            if(num>6)return;
            if(nopol_.size()>0) {
                _nopol[num<0?0:num] = nopol_;
            } else {
                _nopol[num<0?0:num].clear();
            }
            if(km_.size()>0) {
                _km[num<0?0:num] = km_;
            } else {
                _km[num<0?0:num].clear();
            }
        }
    }
    doreset();
    dbg.printf("Plat_no : %s || odo : %s|| nozle : %s\r\n", nopol_.c_str(), km_.c_str(), nozle_.c_str());
}

void input_km()
{
    string km_,nozle_;
    km_ = get_numeric(6,0);
    if(km_.size()>0) {
        nozle_ = get_numeric(6,1);
        if(nozle_.size()>0) {
            int num = atoi(nozle_.c_str())-1;
            _km[num<0?0:num] = km_;
        }
    }
    doreset();
    dbg.printf("Km : %s || nozle : %s\r\n", km_.c_str(), nozle_.c_str());
}

void input_rtc()
{
    string Date_,Time_;
    Date_ += get_numeric(5,0);
    if(Date_.size()>0) {
        Time_ += get_numeric(5,1);
    }
    doreset();
    dbg.printf("Date : %s || Time : %s\r\n", Date_.c_str(), Time_.c_str());

    char temp_year[4];
    char temp_mon[2];
    char temp_day[2];

    char temp_hour[2];
    char temp_min[2];
    char temp_sec[2];

    //for(int i = 0; i<8; i++) {
//        if(i>=0 && i<= 3) {
//            temp_year[i] = Date_[i];
//        } else if(i>=4 && i<= 5) {
//            temp_mon[i] = Date_[i];
//        } else if(i>=6 && i <= 7) {
//            temp_day[i] = Date_[i];
//        }
//    }
//
//    for(int i = 0; i<6; i++) {
//        if(i>=0 && i<= 1) {
//            temp_hour[i] = Time_[i];
//        } else if(i>=2 && i<= 3) {
//            temp_min[i] = Time_[i];
//        } else if(i>=4 && i <= 5) {
//            temp_sec[i] = Time_[i];
//        }
//    }

    temp_year[0] = Date_[0];
    temp_year[1] = Date_[1];
    temp_year[2] = Date_[2];
    temp_year[3] = Date_[3];

    temp_mon[0] = Date_[4];
    temp_mon[1] = Date_[5];

    temp_day[0] = Date_[6];
    temp_day[1] = Date_[7];

    temp_hour[0] = Time_[0];
    temp_hour[1] = Time_[1];

    temp_min[0] = Time_[2];
    temp_min[1] = Time_[3];

    temp_sec[0] = Time_[4];
    temp_sec[1] = Time_[5];

    t.tm_year = atoi(temp_year);
    t.tm_mon = atoi(temp_mon);
    t.tm_mday =  atoi(temp_day);
    t.tm_hour =  atoi(temp_hour);
    t.tm_min = atoi(temp_min);
    t.tm_sec =  atoi(temp_sec);

    t.tm_year = t.tm_year - 1900;
    t.tm_mon = t.tm_mon - 1;

    // set the time
    set_time(mktime(&t));
    time_t seconds = time(NULL);
    printf("RTC Now is = %s \r\n", ctime(&seconds));
}

void setting_rtc()
{
    //string timeku;
//
//    timeku += get_numeric(5,0);
//    timeku += " ";
//
//    dbg.printf("Time : %s\r\n",timeku);
//    if(timeku.size()==11) {
//        timeku+=get_numeric(5,1);
//        if(timeku.size()==19) {
//            if(rtc.set_time(timeku.c_str())) {
//                dbg.printf("Config RTC Success\r\n");
//                time_t xx = rtc.now();
//
//            } else dbg.printf("Config RTC Failed\r\n");
//        } else timeku.clear();
//    } else timeku.clear();
    input_rtc();
}

string Get_Time(){
    string times;
    time_t seconds = time(NULL);
    times = ctime(&seconds);
    return times;
}

uint32_t cbAfterInput(uint32_t index)
{
    KeyIndex = index;
    tekan = true;
    return 0;
}

void init()
{
    lcd.cls();
    lcd.printf("Wait...");
    lcd.setCursor(TextLCD::CurOff_BlkOff);
    wait_ms(1000);
    lcd.setBacklight(TextLCD::LightOff);
    wait_ms(1000);

    lcd.setBacklight(TextLCD::LightOn);
    key.CallAfterInput(&cbAfterInput);
    key.Start();
    tekan = false;
    wait_ms(1000);
    lcd.cls();
}
