#include "mbed.h"
#include "EthernetInterface.h"
#include <string>
#include <vector>
#include "Audio.h"
#include "iButton.h"
#include <bitset>
#include "CRC16Modbus.h"
#include "BufferedSoftSerial.h"
#include "Displays.h"
#include <list>
#include <algorithm>

// Network interface
TCPSocket socket;

Thread thdFindConnection;
Thread thd_Cek_Ibutton;
Thread thd_RS485_Recv;
Thread thd_Buzzer;
Thread thd_LCD;

MyAudio buzz(D7);
Displays dsp(PTC8,PTC1);
uint8_t LCD_Step = 0;
uint8_t LCD_Step_4 = 0;

#define IP         "192.168.0.6"
#define GATEWAY    "192.168.0.1"
#define MASK       "255.255.255.0"

char cmd_resets[] = "R00";
char cek_con[] = "P";

uint8_t Key_On_Process = 0;

Serial dbg(USBTX,USBRX);
BufferedSoftSerial dv(PTB19,PTB18);
DigitalOut rede(PTC9,0);
iButton ibutton(D4);

bool tap = false;
bool lasttap = false;

uint8_t board_number;
uint8_t baris;
uint8_t kolom;
uint8_t real_id;
uint8_t real_blink_id_1 = 64;
uint8_t real_blink_id_2 = 64;
uint8_t real_blink_id_3 = 64;
uint8_t real_blink_id_4 = 64;
uint8_t real_blink_id_5 = 64;
uint8_t blinking_now = 0;

uint8_t ids;

typedef uint8_t byte;
//r0,r1,r2,r3,r4,r5,r6,r7
byte Row_Board1_Last[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board2_Last[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board3_Last[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board4_Last[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board5_Last[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

byte Row_Board1_Now[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board2_Now[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board3_Now[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board4_Now[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board5_Now[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

byte Row_Board1_Predict[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board2_Predict[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board3_Predict[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board4_Predict[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
byte Row_Board5_Predict[8] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

uint8_t board_88[8][8]= {
    {0,1,2,3,4,5,6,7},
    {8,9,10,11,12,13,14,15},
    {16,17,18,19,20,21,22,23},
    {24,25,26,27,28,29,30,31},
    {32,33,34,35,36,37,38,39},
    {40,41,42,43,44,45,46,47},
    {48,49,50,51,52,53,54,55},
    {56,57,58,59,60,61,62,63}
};

string TCP_Cek_Data_Last_Sent;
string TCP_Data_Last_Sent;
string TCP_Ibutton_Last_Sent;

unsigned char buffer_crc[2];
unsigned short _crc;

byte respon_from_slave_temp[17];

bool intr_Done = false;
uint8_t board_sum;

struct frame_data {
    string ids;
    string key_on = "";
    string key_off = "";
}Frame_To_Send;

struct Frame_Data_Received {
    uint8_t ids;
    string ibutton;
    uint8_t _key_id;
    uint8_t cmd_id;
} frm_data_received;

byte respon_from_slave[32];

uint8_t step = 0;
bool Done = false;
bool isConnected = false;

string salah_taruh1;
string salah_ambil1;
string salah_taruh2;
string salah_ambil2;
string salah_taruh3;
string salah_ambil3;
string salah_taruh4;
string salah_ambil4;
string salah_taruh5;
string salah_ambil5;

bool done_1 = true;
bool done_2 = true;
bool done_3 = true;
bool done_4 = true;
bool done_5 = true;

vector<uint8_t> lst_salah;
vector<uint8_t> lst_salah_hst;
vector<uint8_t>::iterator it;
vector<uint8_t> to_remove;

string to_sends;
string to_sends_cek;
string salah_ambil_resultant;
string salah_taruh_resultant;

string ibutton_code;
vector<string> split(const string str, const string separator)
{
    char *cstr = const_cast<char*>(str.c_str());
    char *current;

    std::vector<std::string>arr;
    current = strtok(cstr, separator.c_str());
    while(current != NULL) {
        arr.push_back(current);
        current = strtok(NULL, separator.c_str());
    }
    return arr;
}
bool waiting_resp = false;

void Cek_Ibutton();
void Cek_Salah_Buzzer();
string Byte_to_StringBinary(byte data_byte);
uint8_t StringBinary_to_Byte(string data_binary);
uint8_t Get_Row(uint8_t key_id);
unsigned short Get_CRC_Modbus(byte data_byte[]);
void Send_RS485(uint8_t board,uint8_t key_id,uint8_t key_id_blinking,bool Cek_Respon);
void Make_Prediction(uint8_t board_number,uint8_t baris, uint8_t kolom);
void Cek_LCD_State();

string First_Update();
vector<string> temp_data;
uint8_t res_cmp = 0;
string bin_string_now;
string bin_string_predict;
uint8_t keys;
bool First_Run = true;

void FindingServer()
{
    printf("Finding Server.....\r\n\r\n");

RECONNECT1:
    EthernetInterface net;
    net.set_network(IP,MASK,GATEWAY);
    uint8_t stat1 = net.connect();
    //printf("stat1 = %d\r\n",stat1);
    if(stat1 != 0) {
        goto RECONNECT1;
    }
    // Show the network address
    const char *ip = net.get_ip_address();

    while(1) {
RECONNECT2:
        // Open a socket on the network interface, and create a TCP connection to mbed.org
        TCPSocket socket;
        socket.open(&net);
        socket.set_blocking(false);
        uint8_t stat2 = socket.connect("192.168.0.89", 12345);
        //printf("stat2 = %d\r\n",stat2);
        wait(1);
        if(stat2 != 0) {
            socket.close();
            goto RECONNECT2;
        }

        isConnected = true;
        printf("Connected to Server....\r\n");

        if(First_Run) {
            printf("Process Start..\r\n");
            //socket.send(cmd_resets, sizeof(cmd_resets));

            string data_frame = First_Update();

            socket.send(data_frame.c_str(), data_frame.length());
            First_Run = false;
            wait(0.05);
            dsp.step0();
        } else {
            if(blinking_now == 0) {
                //printf("Process Start..\r\n");
                //socket.send(cmd_resets, sizeof(cmd_resets));

                string data_frame = First_Update();
                step = 0;
                if(frm_data_received.ids == 3) {
                    dsp.step4(to_string(frm_data_received._key_id).c_str(),false);
                } else if(frm_data_received.ids== 1) {
                    dsp.step0();
                } else {
                    dsp.step0();
                }
                socket.send(data_frame.c_str(), data_frame.length());
            } else {
                dsp.step5(to_string(blinking_now).c_str(),true);
            }
        }

        //printf("%s\r\n",data_frame.c_str());
        while(isConnected) {

            //TODO : CekData Locker Terkini

            switch(step) {
                case 0: {

                    uint8_t res_cek = socket.send(cek_con,sizeof(cek_con));

                    if(res_cek <= 0) {
                        printf("Server Has Been Closed..\r\n");
                        isConnected = false;
                        socket.close();
                        dsp.init();
                        continue;
                    }

                    for(uint8_t i = 0; i<board_sum; i++) {
                        wait_ms(50);
                        //printf("%d %d %d %d %d\r\n",real_blink_id_1,real_blink_id_2,real_blink_id_3,real_blink_id_4,real_blink_id_5);
                        if(i == 0) Send_RS485(i,64,real_blink_id_1,true);
                        else if(i == 1) Send_RS485(i,64,real_blink_id_2,true);
                        else if(i == 2) Send_RS485(i,64,real_blink_id_3,true);
                        else if(i == 3) Send_RS485(i,64,real_blink_id_4,true);
                        else if(i == 4) Send_RS485(i,64,real_blink_id_5,true);

                        for(uint8_t a = 4; a<12; a++) {
                            uint8_t temp_id = a;

                            switch(i) {
                                case 0: {
                                    Row_Board1_Now[temp_id-4] = respon_from_slave[a];
                                    //printf("Resp : %02X || BoardLast %d : %02X\r\n",respon_from_slave[a],i+1,Row_Board1_Last[temp_id-5]);
                                }
                                break;
                                case 1: {
                                    Row_Board2_Now[temp_id-4] = respon_from_slave[a];
                                    //printf("Resp : %02X || BoardLast %d : %02X\r\n",respon_from_slave[a],i+1,Row_Board2_Last[temp_id-5]);
                                }
                                break;
                                case 2: {
                                    Row_Board3_Now[temp_id-4] = respon_from_slave[a];
                                    //printf("Resp : %02X || BoardLast %d : %02X\r\n",respon_from_slave[a],i+1,Row_Board3_Last[temp_id-5]);
                                }
                                break;
                                case 3: {
                                    Row_Board4_Now[temp_id-4] = respon_from_slave[a];
                                    //printf("Resp : %02X || BoardLast %d : %02X\r\n",respon_from_slave[a],i+1,Row_Board4_Last[temp_id-5]);
                                }
                                break;
                                case 4: {
                                    Row_Board5_Now[temp_id-4] = respon_from_slave[a];
                                    //printf("Resp : %02X || BoardLast %d : %02X\r\n",respon_from_slave[a],i+1,Row_Board5_Last[temp_id-5]);
                                }
                                break;
                            }
                        }
                    }

                    salah_ambil1 = "";
                    salah_taruh1 = "";
                    salah_ambil2 = "";
                    salah_taruh2 = "";
                    salah_ambil3 = "";
                    salah_taruh3 = "";
                    salah_ambil4 = "";
                    salah_taruh4 = "";
                    salah_ambil5 = "";
                    salah_taruh5 = "";

                    lst_salah.clear();
                    to_remove.clear();
                    for(uint8_t i = 0; i<board_sum; i++) {
                        switch(i) {
                            case 0: {
                                res_cmp = 0;
                                res_cmp = memcmp(Row_Board1_Now,Row_Board1_Last, sizeof(Row_Board1_Now));
                                if(res_cmp != 0) {
                                    for(uint8_t j = 0; j<8; j++) {
                                        if(Row_Board1_Now[j] != Row_Board1_Last[j]) {
                                            bin_string_now = "";
                                            bin_string_predict = "";
                                            keys = 0;
                                            bin_string_now =  Byte_to_StringBinary(Row_Board1_Now[j]);
                                            bin_string_predict = Byte_to_StringBinary(Row_Board1_Last[j]);

                                            for (uint8_t k = 0; k < 8; k++) {
                                                if(bin_string_now[abs(k-7)] != bin_string_predict[abs(k-7)]) {
                                                    keys = (40*j)+k+(8*i)+1;
                                                    done_1 = false;
                                                    lst_salah.push_back(keys);

                                                    if(bin_string_predict[abs(k-7)] == '0') {
                                                        salah_taruh1 += to_string(keys)+"-";
                                                    } else {
                                                        salah_ambil1 += to_string(keys)+"-";
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else if (res_cmp == 0) {
                                    real_blink_id_1 = 64;
                                    salah_ambil1 = "";
                                    salah_taruh1 = "";
                                    done_1 = true;

                                    //memcpy(Row_Board1_Last,Row_Board1_Now,sizeof(Row_Board1_Last));

                                    Send_RS485(i,64,64,false);
                                }

                            }
                            break;
                            case 1: {
                                res_cmp = 0;
                                res_cmp = memcmp(Row_Board2_Now,Row_Board2_Last, sizeof(Row_Board2_Now));
                                if(res_cmp != 0) {
                                    for(uint8_t j = 0; j<8; j++) {
                                        if(Row_Board2_Now[j] != Row_Board2_Last[j]) {
                                            bin_string_now = "";
                                            bin_string_predict = "";
                                            keys = 0;
                                            bin_string_now =  Byte_to_StringBinary(Row_Board2_Now[j]);
                                            bin_string_predict = Byte_to_StringBinary(Row_Board2_Last[j]);

                                            for (uint8_t k = 0; k < 8; k++) {
                                                if(bin_string_now[abs(k-7)] != bin_string_predict[abs(k-7)]) {
                                                    keys = (40*j)+k+(8*i)+1;
                                                    lst_salah.push_back(keys);
                                                    done_2 = false;

                                                    if(bin_string_predict[abs(k-7)] == '0') {
                                                        salah_taruh2 += to_string(keys)+"-";
                                                    } else {
                                                        salah_ambil2 += to_string(keys)+"-";
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else if (res_cmp == 0) {
                                    real_blink_id_2 = 64;
                                    salah_ambil2 = "";
                                    salah_taruh2 = "";
                                    done_2 = true;

                                    //memcpy(Row_Board2_Last,Row_Board2_Now,sizeof(Row_Board2_Last));

                                    Send_RS485(i,64,64,false);
                                }
                            }
                            break;
                            case 2: {
                                res_cmp = 0;
                                res_cmp = memcmp(Row_Board3_Now,Row_Board3_Last, sizeof(Row_Board3_Now));
                                if(res_cmp != 0) {
                                    for(uint8_t j = 0; j<8; j++) {
                                        if(Row_Board3_Now[j] != Row_Board3_Last[j]) {
                                            bin_string_now = "";
                                            bin_string_predict = "";
                                            keys = 0;
                                            bin_string_now =  Byte_to_StringBinary(Row_Board3_Now[j]);
                                            bin_string_predict = Byte_to_StringBinary(Row_Board3_Last[j]);

                                            for (uint8_t k = 0; k < 8; k++) {
                                                if(bin_string_now[abs(k-7)] != bin_string_predict[abs(k-7)]) {
                                                    keys = (40*j)+k+(8*i)+1;
                                                    lst_salah.push_back(keys);
                                                    done_3 = false;

                                                    if(bin_string_predict[abs(k-7)] == '0') {
                                                        salah_taruh3 += to_string(keys)+"-";
                                                    } else {
                                                        salah_ambil3 += to_string(keys)+"-";
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else if (res_cmp == 0) {
                                    real_blink_id_3 = 64;
                                    salah_ambil3 = "";
                                    salah_taruh3 = "";
                                    done_3 = true;

                                    //memcpy(Row_Board3_Last,Row_Board3_Now,sizeof(Row_Board3_Last));

                                    Send_RS485(i,64,64,false);
                                }
                            }
                            break;
                            case 3: {
                                res_cmp = 0;
                                res_cmp = memcmp(Row_Board4_Now,Row_Board4_Last, sizeof(Row_Board4_Now));
                                if(res_cmp != 0) {
                                    for(uint8_t j = 0; j<8; j++) {
                                        if(Row_Board4_Now[j] != Row_Board4_Last[j]) {
                                            bin_string_now = "";
                                            bin_string_predict = "";
                                            keys = 0;
                                            bin_string_now =  Byte_to_StringBinary(Row_Board4_Now[j]);
                                            bin_string_predict = Byte_to_StringBinary(Row_Board4_Last[j]);

                                            for (uint8_t k = 0; k < 8; k++) {
                                                if(bin_string_now[abs(k-7)] != bin_string_predict[abs(k-7)]) {
                                                    keys = (40*j)+k+(8*i)+1;
                                                    lst_salah.push_back(keys);
                                                    done_4 = false;

                                                    if(bin_string_predict[abs(k-7)] == '0') {
                                                        salah_taruh4 += to_string(keys)+"-";
                                                    } else {
                                                        salah_ambil4 += to_string(keys)+"-";
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else if (res_cmp == 0) {
                                    real_blink_id_4 = 64;
                                    salah_ambil4 = "";
                                    salah_taruh4 = "";
                                    done_4 = true;

                                    //memcpy(Row_Board3_Last,Row_Board3_Now,sizeof(Row_Board3_Last));

                                    Send_RS485(i,64,64,false);
                                }
                            }
                            break;
                            case 4: {
                                res_cmp = 0;
                                res_cmp = memcmp(Row_Board5_Now,Row_Board5_Last, sizeof(Row_Board5_Now));
                                if(res_cmp != 0) {
                                    for(uint8_t j = 0; j<8; j++) {
                                        if(Row_Board5_Now[j] != Row_Board5_Last[j]) {
                                            bin_string_now = "";
                                            bin_string_predict = "";
                                            keys = 0;
                                            bin_string_now =  Byte_to_StringBinary(Row_Board5_Now[j]);
                                            bin_string_predict = Byte_to_StringBinary(Row_Board5_Last[j]);

                                            for (uint8_t k = 0; k < 8; k++) {
                                                if(bin_string_now[abs(k-7)] != bin_string_predict[abs(k-7)]) {
                                                    keys = (40*j)+k+(8*i)+1;
                                                    lst_salah.push_back(keys);
                                                    done_5 = false;

                                                    if(bin_string_predict[abs(k-7)] == '0') {
                                                        salah_taruh5 += to_string(keys)+"-";
                                                    } else {
                                                        salah_ambil5 += to_string(keys)+"-";
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else if (res_cmp == 0) {
                                    real_blink_id_5 = 64;
                                    salah_ambil5 = "";
                                    salah_taruh5 = "";
                                    done_5 = true;

                                    //memcpy(Row_Board3_Last,Row_Board3_Now,sizeof(Row_Board3_Last));

                                    Send_RS485(i,64,64,false);
                                }
                            }
                            break;
                        }
                    }

                    salah_ambil_resultant = "";
                    salah_taruh_resultant = "";

                    if(lst_salah.size() > 0) {

                        uint8_t blink_id = 64;

                        bool ada = false;

                        if(lst_salah_hst.size() > 0) {

                            printf("jumlah hst = %d\r\n",lst_salah_hst.size());
                            for(uint8_t q = 0; q<lst_salah_hst.size(); q++) {
                                ada = false;
                                printf("lst_hst_recent%d = %d\r\n",q+1,lst_salah_hst[q]);

                                for(uint8_t r = 0; r<lst_salah.size(); r++) {
                                    if(lst_salah[r] == lst_salah_hst[q]) {
                                        ada = true;
                                    }
                                }
                                if(!ada) {
                                    to_remove.push_back(lst_salah_hst[q]);
                                }
                            }

                            if(to_remove.size() > 0) {
                                for(uint8_t t = 0; t<to_remove.size(); t++) {
                                    lst_salah_hst.erase(remove(lst_salah_hst.begin(), lst_salah_hst.end(), to_remove[t]), lst_salah_hst.end());
                                }
                            }

                            for(uint8_t w = 0; w<lst_salah.size(); w++) {
                                it = find (lst_salah_hst.begin(), lst_salah_hst.end(), lst_salah[w]);
                                if (it != lst_salah_hst.end()) {
                                    continue;
                                }
                                lst_salah_hst.push_back(lst_salah[w]);
                            }
                        } else {
                            for(uint8_t u = 0; u<lst_salah.size(); u++) {
                                lst_salah_hst.push_back(lst_salah[u]);
                            }

                        }

                        blink_id = lst_salah_hst[lst_salah_hst.size()-1];

                        uint8_t board_number_blink = (blink_id - 1)%40;

                        if(board_number_blink>= 0 && board_number_blink<= 7)board_number_blink = 0;
                        else if(board_number_blink>= 8 && board_number_blink<= 15)board_number_blink = 1;
                        else if(board_number_blink>= 16 && board_number_blink<= 23)board_number_blink = 2;
                        else if(board_number_blink>= 24 && board_number_blink<= 31)board_number_blink = 3;
                        else if(board_number_blink>= 32 && board_number_blink<= 39)board_number_blink = 4;

                        //printf("board_number_blink = %d\r\n",board_number_blink);

                        uint8_t baris_blink = (blink_id - 1)/40;
                        uint8_t kolom_blink = (blink_id - 1)%8;
                        blink_id = board_88[baris_blink][kolom_blink];

                        //printf("Board blink : %d,Kolom blink : %d, Baris blink : %d\r\n",board_number_blink,kolom_blink,baris_blink);
                        if(board_number_blink == 0) {
                            real_blink_id_1 = blink_id;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = 64;
                        } else if(board_number_blink == 1) {
                            real_blink_id_1 = 64;
                            real_blink_id_2 = blink_id;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = 64;
                        } else if(board_number_blink == 2) {
                            real_blink_id_1 = 64;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = blink_id;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = 64;
                        } else if(board_number_blink == 3) {
                            real_blink_id_1 = 64;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = blink_id;
                            real_blink_id_5 = 64;
                        } else if(board_number_blink == 4) {
                            real_blink_id_1 = 64;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = blink_id;
                        }
                        blinking_now = lst_salah_hst[lst_salah_hst.size()-1];

                        salah_ambil_resultant = salah_ambil1 + salah_ambil2 + salah_ambil3 + salah_ambil4 + salah_ambil5;
                        salah_taruh_resultant = salah_taruh1 + salah_taruh2 + salah_taruh3 + salah_taruh4 + salah_taruh5;

                        if(salah_ambil_resultant == "") salah_ambil_resultant = "0-";
                        if(salah_taruh_resultant == "") salah_taruh_resultant = "0-";

                        to_sends_cek = "2;"+salah_ambil_resultant + ";" +salah_taruh_resultant+";" + to_string(blinking_now) +";~";
                        printf("Unprosedur : %s\r\n",to_sends_cek.c_str());

                        if(TCP_Cek_Data_Last_Sent.find(to_sends_cek) == -1) {
                            dsp.step5(to_string(blinking_now).c_str(),true);
                            socket.send(to_sends_cek.c_str(), to_sends_cek.length());

                            TCP_Cek_Data_Last_Sent = to_sends_cek;
                        }
                    } else {
                        if(done_1 && done_2 && done_3 && done_4 && done_5) {
                            lst_salah_hst.clear();
                            blinking_now = 0;
                            real_blink_id_1 = 64;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = 64;

                            salah_ambil_resultant = "0;";
                            salah_taruh_resultant = "0";

                            step = 1;

                            to_sends_cek = "2;0-;0-;~";

                            if(TCP_Cek_Data_Last_Sent.find(to_sends_cek) == -1) {
                                if(frm_data_received.ids == 3) {
                                    dsp.step4(to_string(frm_data_received._key_id).c_str(),false);
                                } else if(frm_data_received.ids== 1) {
                                    dsp.step0();
                                } else {
                                    dsp.step0();
                                }
                                //wait_ms(50);
                                socket.send(to_sends_cek.c_str(), to_sends_cek.length());
                                TCP_Cek_Data_Last_Sent = to_sends_cek;
                            }

                        } else {
                            blinking_now = 0;
                            real_blink_id_1 = 64;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = 64;
                        }
                    }
                }
                break;

                case 1: {
                    char rbuffer[64];

                    uint8_t rcount = socket.recv(rbuffer, sizeof rbuffer);
                    if(rcount < 0) {
                        step = 0;
                    } else if(rcount > 0) {
                        rbuffer[rcount] = '\0';

                        string data;

                        for(uint8_t i = 0; i<sizeof(rbuffer); i++) {
                            if(rbuffer[i] == '\0')break;
                            data += rbuffer[i];
                        }

                        vector<string> res = split(data, "~");

                        if(sizeof(res) != 0) {
                            temp_data = split(res[0], ";");

                            if(temp_data[0] == "3" && temp_data[1] == "1") {
                                dsp.step4(to_string(frm_data_received._key_id).c_str(),false);
                            } else if(temp_data[0] == "3" && temp_data[1] == "0") {
                                dsp.step0();
                            } else {
                                frm_data_received.ids = atoi(temp_data[0].c_str());
                                frm_data_received.ibutton = temp_data[1];
                                frm_data_received._key_id = atoi(temp_data[2].c_str());
                                frm_data_received.cmd_id = atoi(temp_data[3].c_str());


                                printf("id = %d\r\n",frm_data_received.ids);
                                printf("ibutton = %s\r\n",frm_data_received.ibutton.c_str());
                                printf("keys = %d\r\n",frm_data_received._key_id);
                                printf("cmd = %d\r\n",frm_data_received.cmd_id);

                                if(frm_data_received.ids== 1) {
                                    wait(1);
                                    dsp.step1(true);
                                    step = 2;
                                } else if(frm_data_received.ids == 3) {
                                    step = 3;

                                    //dsp.step4(to_string(frm_data_received._key_id).c_str(),true);
                                }
                            }
                        }
                    } else if(rcount == 0) {
                        printf("Server Has Been Closed..\r\n");

                        isConnected = false;
                        step = 0;//
//                        blinking_now = 0;
//                        real_blink_id_1 = 64;
//                        real_blink_id_2 = 64;
//                        real_blink_id_3 = 64;
//                        real_blink_id_4 = 64;
//                        real_blink_id_5 = 64;
                        dsp.init();
                        socket.close();
                    }

                    if(ibutton_code != "") {
                        string data_to_send = "3;" + ibutton_code + ";~";
                        printf("%s\r\n",data_to_send.c_str());
                        wait(1);

                        socket.send(data_to_send.c_str(), data_to_send.length());
                        TCP_Ibutton_Last_Sent = data_to_send;
                        printf("Send ibutton\r\n");

                        ibutton_code.clear();
                    }
                }
                break;

                case 2: {
                    buzz.play(1);
                    bool restart = false;
                    while(frm_data_received.ibutton.c_str() != ibutton_code) {
                        uint8_t res_cek = socket.send(cek_con,sizeof(cek_con));

                        if(res_cek <= 0) {
                            printf("Server Has Been Closed..\r\n");
                            isConnected = false;
                            socket.close();
                            dsp.init();
                            restart = true;
                            break;
                        }
                        wait(0.05);
                    }
                    if(restart) {
                        continue;
                    } else {
                        ibutton_code.clear();
                        printf("IButton verified\r\n");
                        dsp.step2(to_string(frm_data_received._key_id).c_str());
                        step = 3;

                    }
                }
                break;

                case 3: {
                    uint8_t res_cek = socket.send(cek_con,sizeof(cek_con));

                    if(res_cek <= 0) {
                        printf("Server Has Been Closed..\r\n");
                        isConnected = false;
                        socket.close();
                        dsp.init();
                        continue;
                    }

                    buzz.play(1);

                    board_number = (frm_data_received._key_id - 1)%40;

                    if(board_number>= 0 && board_number<= 7)board_number = 0;
                    if(board_number>= 8 && board_number<= 15)board_number = 1;
                    if(board_number>= 16 && board_number<= 23)board_number = 2;
                    if(board_number>= 24 && board_number<= 31)board_number = 3;
                    if(board_number>= 32 && board_number<= 39)board_number = 4;
                    printf("KEY[board] = %d\r\n",board_number);
                    baris = (frm_data_received._key_id - 1)/40;
                    printf("KEY[baris] = %d\r\n",baris);
                    kolom = (frm_data_received._key_id - 1)%8;
                    printf("KEY[kolom] = %d\r\n",kolom);

                    real_id = board_88[baris][kolom];
                    printf("Real Id = %d\r\n",real_id);

                    Make_Prediction(board_number,baris,kolom);

                    step = 4;

                }
                break;

                case 4: {
                    uint8_t res_cek = socket.send(cek_con,sizeof(cek_con));

                    if(res_cek <= 0) {
                        LCD_Step_4 = 0;
                        printf("Server Has Been Closed..\r\n");
                        isConnected = false;
                        socket.close();
                        dsp.init();
                        continue;
                    }

                    for(uint8_t i = 0; i<board_sum; i++) {
                        wait_ms(100);
                        if(board_number == i) {
                            if(i == 0) Send_RS485(i,real_id,real_blink_id_1,true);
                            else if(i == 1) Send_RS485(i,real_id,real_blink_id_2,true);
                            else if(i == 2) Send_RS485(i,real_id,real_blink_id_3,true);
                            else if(i == 3) Send_RS485(i,real_id,real_blink_id_4,true);
                            else if(i == 4) Send_RS485(i,real_id,real_blink_id_5,true);
                        } else {
                            if(i == 0) Send_RS485(i,64,real_blink_id_1,true);
                            else if(i == 1) Send_RS485(i,64,real_blink_id_2,true);
                            else if(i == 2) Send_RS485(i,64,real_blink_id_3,true);
                            else if(i == 3) Send_RS485(i,64,real_blink_id_4,true);
                            else if(i == 4) Send_RS485(i,64,real_blink_id_5,true);
                        }

                        printf("Data has been received successfully\r\n");
                        for(uint8_t a = 4; a<12; a++) {
                            uint8_t temp_id = a;

                            switch(i) {
                                case 0: {
                                    Row_Board1_Now[temp_id-4] = respon_from_slave[a];
                                }
                                break;
                                case 1: {
                                    Row_Board2_Now[temp_id-4] = respon_from_slave[a];
                                    //printf("Resp : %02X || BoardLast %d : %02X\r\n",respon_from_slave[a],i+1,Row_Board2_Last[temp_id-5]);
                                }
                                break;
                                case 2: {
                                    Row_Board3_Now[temp_id-4] = respon_from_slave[a];
                                    //printf("Resp : %02X || BoardLast %d : %02X\r\n",respon_from_slave[a],i+1,Row_Board3_Last[temp_id-5]);
                                }
                                break;
                                case 3: {
                                    Row_Board4_Now[temp_id-4] = respon_from_slave[a];
                                    //printf("Resp : %02X || BoardLast %d : %02X\r\n",respon_from_slave[a],i+1,Row_Board4_Last[temp_id-5]);
                                }
                                break;
                                case 4: {
                                    Row_Board5_Now[temp_id-4] = respon_from_slave[a];
                                    //printf("Resp : %02X || BoardLast %d : %02X\r\n",respon_from_slave[a],i+1,Row_Board5_Last[temp_id-5]);
                                }
                                break;
                            }
                        }
                    }

                    salah_ambil1 = "";
                    salah_taruh1 = "";
                    salah_ambil2 = "";
                    salah_taruh2 = "";
                    salah_ambil3 = "";
                    salah_taruh3 = "";
                    salah_ambil4 = "";
                    salah_taruh4 = "";
                    salah_ambil5 = "";
                    salah_taruh5 = "";

                    lst_salah.clear();

                    for(uint8_t i = 0; i<board_sum; i++) {
                        switch(i) {
                            case 0: {
                                string salah_1;
                                res_cmp = 0;
                                res_cmp = memcmp(Row_Board1_Now,Row_Board1_Predict, sizeof(Row_Board1_Now));
                                if(res_cmp != 0) {
                                    for(uint8_t j = 0; j<8; j++) {
                                        if(Row_Board1_Now[j] != Row_Board1_Predict[j]) {
                                            bin_string_now = "";
                                            bin_string_predict = "";
                                            keys = 0;
                                            bin_string_now =  Byte_to_StringBinary(Row_Board1_Now[j]);
                                            bin_string_predict = Byte_to_StringBinary(Row_Board1_Predict[j]);

                                            for (uint8_t k = 0; k < 8; k++) {
                                                if(bin_string_now[abs(k-7)] != bin_string_predict[abs(k-7)]) {
                                                    keys = (40*j)+k+(8*i)+1;
                                                    if(keys != frm_data_received._key_id) {
                                                        lst_salah.push_back(keys);
                                                        salah_1 += to_string(keys)+"-";
                                                    } else {
                                                        done_1 = false;
                                                    }

                                                    if(bin_string_predict[abs(k-7)] == '0') {
                                                        if(keys != frm_data_received._key_id) {
                                                            salah_taruh1 += to_string(keys)+"-";
                                                        }
                                                    } else {
                                                        if(keys != frm_data_received._key_id) {
                                                            salah_ambil1 += to_string(keys)+"-";

                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    printf("Salah_Board%d = %s\r\n",i+1,salah_1.c_str());
                                } else if (res_cmp == 0) {
                                    printf("Board %d Match\r\n",i+1);
                                    real_blink_id_1 = 64;
                                    salah_ambil1 = "";
                                    salah_taruh1 = "";
                                    done_1 = true;

                                    memcpy(Row_Board1_Last,Row_Board1_Now,sizeof(Row_Board1_Last));

                                    Send_RS485(i,64,64,false);
                                }

                            }
                            break;
                            case 1: {
                                string salah_2;
                                res_cmp = 0;
                                res_cmp = memcmp(Row_Board2_Now,Row_Board2_Predict, sizeof(Row_Board2_Now));
                                if(res_cmp != 0) {
                                    for(uint8_t j = 0; j<8; j++) {
                                        if(Row_Board2_Now[j] != Row_Board2_Predict[j]) {
                                            bin_string_now = "";
                                            bin_string_predict = "";
                                            keys = 0;
                                            bin_string_now =  Byte_to_StringBinary(Row_Board2_Now[j]);
                                            bin_string_predict = Byte_to_StringBinary(Row_Board2_Predict[j]);

                                            for (uint8_t k = 0; k < 8; k++) {
                                                if(bin_string_now[abs(k-7)] != bin_string_predict[abs(k-7)]) {
                                                    keys = (40*j)+k+(8*i)+1;
                                                    if(keys != frm_data_received._key_id) {
                                                        lst_salah.push_back(keys);
                                                        salah_2 += to_string(keys)+"-";
                                                    } else {
                                                        done_2 = false;
                                                    }

                                                    if(bin_string_predict[abs(k-7)] == '0') {
                                                        if(keys != frm_data_received._key_id) {
                                                            salah_taruh2 += to_string(keys)+"-";
                                                        }
                                                    } else {
                                                        if(keys != frm_data_received._key_id) {
                                                            salah_ambil2 += to_string(keys)+"-";
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    printf("Salah_Board%d = %s\r\n",i+1,salah_2.c_str());
                                } else if (res_cmp == 0) {
                                    printf("Board %d Match\r\n",i+1);
                                    real_blink_id_2 = 64;
                                    salah_ambil2 = "";
                                    salah_taruh2 = "";
                                    done_2 = true;

                                    memcpy(Row_Board2_Last,Row_Board2_Now,sizeof(Row_Board2_Last));

                                    Send_RS485(i,64,64,false);
                                }
                            }
                            break;
                            case 2: {
                                string salah_3;
                                res_cmp = 0;
                                res_cmp = memcmp(Row_Board3_Now,Row_Board3_Predict, sizeof(Row_Board3_Now));
                                if(res_cmp != 0) {
                                    for(uint8_t j = 0; j<8; j++) {
                                        if(Row_Board3_Now[j] != Row_Board3_Predict[j]) {
                                            bin_string_now = "";
                                            bin_string_predict = "";
                                            keys = 0;
                                            bin_string_now =  Byte_to_StringBinary(Row_Board3_Now[j]);
                                            bin_string_predict = Byte_to_StringBinary(Row_Board3_Predict[j]);

                                            for (uint8_t k = 0; k < 8; k++) {
                                                if(bin_string_now[abs(k-7)] != bin_string_predict[abs(k-7)]) {
                                                    keys = (40*j)+k+(8*i)+1;
                                                    if(keys != frm_data_received._key_id) {
                                                        lst_salah.push_back(keys);
                                                        salah_3 += to_string(keys)+"-";
                                                    } else {
                                                        done_3 = false;
                                                    }

                                                    if(bin_string_predict[abs(k-7)] == '0') {
                                                        if(keys != frm_data_received._key_id) {
                                                            salah_taruh3 += to_string(keys)+"-";
                                                        }
                                                    } else {
                                                        if(keys != frm_data_received._key_id) {
                                                            salah_ambil3 += to_string(keys)+"-";
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    printf("Salah_Board%d = %s\r\n",i+1,salah_3.c_str());
                                } else if (res_cmp == 0) {
                                    printf("Board %d Match\r\n",i+1);
                                    real_blink_id_3 = 64;
                                    salah_ambil3 = "";
                                    salah_taruh3 = "";
                                    done_3 = true;

                                    memcpy(Row_Board3_Last,Row_Board3_Now,sizeof(Row_Board3_Last));

                                    Send_RS485(i,64,64,false);
                                }
                            }
                            break;
                            case 3: {
                                string salah_4;
                                res_cmp = 0;
                                res_cmp = memcmp(Row_Board4_Now,Row_Board4_Predict, sizeof(Row_Board4_Now));
                                if(res_cmp != 0) {
                                    for(uint8_t j = 0; j<8; j++) {
                                        if(Row_Board1_Now[j] != Row_Board4_Predict[j]) {
                                            bin_string_now = "";
                                            bin_string_predict = "";
                                            keys = 0;
                                            bin_string_now =  Byte_to_StringBinary(Row_Board4_Now[j]);
                                            bin_string_predict = Byte_to_StringBinary(Row_Board4_Predict[j]);

                                            for (uint8_t k = 0; k < 8; k++) {
                                                if(bin_string_now[abs(k-7)] != bin_string_predict[abs(k-7)]) {
                                                    keys = (40*j)+k+(8*i)+1;
                                                    if(keys != frm_data_received._key_id) {
                                                        lst_salah.push_back(keys);
                                                        salah_4 += to_string(keys)+"-";
                                                    } else {
                                                        done_4 = false;
                                                    }

                                                    if(bin_string_predict[abs(k-7)] == '0') {
                                                        if(keys != frm_data_received._key_id) {
                                                            salah_taruh4 += to_string(keys)+"-";
                                                        }
                                                    } else {
                                                        if(keys != frm_data_received._key_id) {
                                                            salah_ambil4 += to_string(keys)+"-";

                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    printf("Salah_Board%d = %s\r\n",i+1,salah_4.c_str());
                                } else if (res_cmp == 0) {
                                    printf("Board %d Match\r\n",i+1);
                                    real_blink_id_4 = 64;
                                    salah_ambil4 = "";
                                    salah_taruh4 = "";
                                    done_4 = true;

                                    memcpy(Row_Board4_Last,Row_Board4_Now,sizeof(Row_Board4_Last));

                                    Send_RS485(i,64,64,false);
                                }
                            }
                            break;
                            case 4: {
                                string salah_5;
                                res_cmp = 0;
                                res_cmp = memcmp(Row_Board5_Now,Row_Board5_Predict, sizeof(Row_Board5_Now));
                                if(res_cmp != 0) {
                                    for(uint8_t j = 0; j<8; j++) {
                                        if(Row_Board1_Now[j] != Row_Board5_Predict[j]) {
                                            bin_string_now = "";
                                            bin_string_predict = "";
                                            keys = 0;
                                            bin_string_now =  Byte_to_StringBinary(Row_Board5_Now[j]);
                                            bin_string_predict = Byte_to_StringBinary(Row_Board5_Predict[j]);

                                            for (uint8_t k = 0; k < 8; k++) {
                                                if(bin_string_now[abs(k-7)] != bin_string_predict[abs(k-7)]) {
                                                    keys = (40*j)+k+(8*i)+1;
                                                    if(keys != frm_data_received._key_id) {
                                                        lst_salah.push_back(keys);
                                                        salah_5 += to_string(keys)+"-";
                                                    } else {
                                                        done_5 = false;
                                                    }

                                                    if(bin_string_predict[abs(k-7)] == '0') {
                                                        if(keys != frm_data_received._key_id) {
                                                            salah_taruh5 += to_string(keys)+"-";
                                                        }
                                                    } else {
                                                        if(keys != frm_data_received._key_id) {
                                                            salah_ambil5 += to_string(keys)+"-";
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    printf("Salah_Board%d = %s\r\n",i+1,salah_5.c_str());
                                } else if (res_cmp == 0) {
                                    printf("Board %d Match\r\n",i+1);
                                    real_blink_id_5 = 64;
                                    salah_ambil5 = "";
                                    salah_taruh5 = "";
                                    done_5 = true;

                                    memcpy(Row_Board5_Last,Row_Board5_Now,sizeof(Row_Board5_Last));

                                    Send_RS485(i,64,64,false);
                                }
                            }
                            break;
                        }
                    }

                    salah_ambil_resultant = "";
                    salah_taruh_resultant = "";
                    printf("Size salah = %d\r\n",lst_salah.size());
                    if(lst_salah.size() > 0) {
                        uint8_t blink_id = 64;

                        bool ada = false;
                        for(uint8_t p = 0; p<lst_salah.size(); p++) printf("lst salah all%d = %d\r\n",p+1,lst_salah[p]);

                        if(lst_salah_hst.size() != 0) {

                            //printf("jumlah hst = %d\r\n",lst_salah_hst.size());
                            for(uint8_t q = 0; q<lst_salah_hst.size(); q++) {
                                ada = false;

                                for(uint8_t r = 0; r<lst_salah.size(); r++) {
                                    if(lst_salah[r] == lst_salah_hst[q]) {
                                        ada = true;
                                        //break;
                                    }
                                }
                                if(!ada) {
                                    to_remove.push_back(lst_salah_hst[q]);
                                }
                            }

                            if(to_remove.size() > 0) {
                                for(uint8_t t = 0; t<to_remove.size(); t++) {
                                    lst_salah_hst.erase(remove(lst_salah_hst.begin(), lst_salah_hst.end(), to_remove[t]), lst_salah_hst.end());
                                }
                            }

                            for(uint8_t w = 0; w<lst_salah.size(); w++) {
                                it = find (lst_salah_hst.begin(), lst_salah_hst.end(), lst_salah[w]);
                                if (it != lst_salah_hst.end()) {
                                    continue;
                                }
                                lst_salah_hst.push_back(lst_salah[w]);
                            }
                        } else {

                            for(uint8_t u = 0; u<lst_salah.size(); u++) {
                                lst_salah_hst.push_back(lst_salah[u]);
                            }
                        }

                        blink_id = lst_salah_hst[lst_salah_hst.size()-1];
                        //printf("blink_id = %d\r\n",blink_id);

                        uint8_t board_number_blink = (blink_id - 1)%40;

                        if(board_number_blink>= 0 && board_number_blink<= 7)board_number_blink = 0;
                        else if(board_number_blink>= 8 && board_number_blink<= 15)board_number_blink = 1;
                        else if(board_number_blink>= 16 && board_number_blink<= 23)board_number_blink = 2;
                        else if(board_number_blink>= 24 && board_number_blink<= 31)board_number_blink = 3;
                        else if(board_number_blink>= 32 && board_number_blink<= 39)board_number_blink = 4;

                        //printf("board_number_blink = %d\r\n",board_number_blink);

                        uint8_t baris_blink = (blink_id - 1)/40;
                        uint8_t kolom_blink = (blink_id - 1)%8;

                        blink_id = board_88[baris_blink][kolom_blink];

                        printf("Board blink : %d,Kolom blink : %d, Baris blink : %d\r\n",board_number_blink,kolom_blink,baris_blink);
                        if(board_number_blink == 0) {
                            real_blink_id_1 = blink_id;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = 64;
                        } else if(board_number_blink == 1) {
                            real_blink_id_1 = 64;
                            real_blink_id_2 = blink_id;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = 64;
                        } else if(board_number_blink == 2) {
                            real_blink_id_1 = 64;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = blink_id;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = 64;
                        } else if(board_number_blink == 3) {
                            real_blink_id_1 = 64;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = blink_id;
                            real_blink_id_5 = 64;
                        } else if(board_number_blink == 4) {
                            real_blink_id_1 = 64;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = blink_id;
                        }
                        blinking_now = lst_salah_hst[lst_salah_hst.size()-1];
                        salah_ambil_resultant = salah_ambil1 + salah_ambil2 + salah_ambil3 + salah_ambil4 + salah_ambil5;
                        salah_taruh_resultant = salah_taruh1 + salah_taruh2 + salah_taruh3 + salah_taruh4 + salah_taruh5;

                        if(salah_ambil_resultant == "") salah_ambil_resultant = "0-";
                        if(salah_taruh_resultant == "") salah_taruh_resultant = "0-";

                        to_sends = to_string(frm_data_received.ids) + ";" +salah_ambil_resultant+";"+salah_taruh_resultant+ ";"+to_string(blinking_now) +";~";

                        if(TCP_Data_Last_Sent.find(to_sends) == -1) {
                            dsp.step5(to_string(blinking_now).c_str(),true);
                            LCD_Step_4 = 0;
                            socket.send(to_sends.c_str(), to_sends.length());
                            TCP_Data_Last_Sent = to_sends;
                        }
                    } else {
                        if(done_1 && done_2 && done_3 && done_4 && done_5) {
                            lst_salah_hst.clear();
                            real_blink_id_1 = 64;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = 64;
                            blinking_now = 0;
                            printf("Finish\r\n");
                            salah_ambil_resultant = "0-";
                            salah_taruh_resultant = "0-";
                            ibutton_code.clear();

                            to_sends = to_string(frm_data_received.ids) + ";"+salah_ambil_resultant+";"+salah_taruh_resultant+";~";

                            socket.send(to_sends.c_str(), to_sends.length());

                            to_sends = "";
                            LCD_Step_4 = 0;

                            step = 0;

                            if(frm_data_received.ids == 3) {
                                dsp.step4(to_string(frm_data_received._key_id).c_str(),false);
                            } else if(frm_data_received.ids == 1) {
                                dsp.step0();
                            }
                        } else {
                            real_blink_id_1 = 64;
                            real_blink_id_2 = 64;
                            real_blink_id_3 = 64;
                            real_blink_id_4 = 64;
                            real_blink_id_5 = 64;
                            blinking_now = 0;

                            if(LCD_Step_4 == 0) {
                                if(frm_data_received.ids== 1) {
                                    dsp.step2(to_string(frm_data_received._key_id).c_str());
                                    wait(1);
                                    LCD_Step_4 = 1;
                                } else if(frm_data_received.ids == 3) {
                                    dsp.step4(to_string(frm_data_received._key_id).c_str(),true);
                                    wait(1);
                                    LCD_Step_4 = 1;
                                }
                            }
                        }
                    }

                }
                break;
            }
        }
    }
}

int main()
{
    //serial_rx_tick.attach(&RS485_Recv,0.01);
    TCP_Cek_Data_Last_Sent = "2;0-;0-;~";
    ids = 0;
    board_sum = 5;
    wait(0.01);
    dsp.init();

    thd_Cek_Ibutton.start(Cek_Ibutton);
    thd_Buzzer.start(Cek_Salah_Buzzer);
    //thd_LCD.start(Cek_LCD_State);
    //thd_RS485_Recv.start(RS485_Recv);

    FindingServer();
}

string Byte_to_StringBinary(byte data_byte)
{
    string data_temp;
    for(uint8_t i = 0; i <8; i++) {
        if((data_byte>>i)&0x01) {
            data_temp[abs(i-7)] += '1';
        } else data_temp[abs(i-7)] += '0';
    }
    return data_temp;
}

uint8_t StringBinary_to_Byte(string data_binary)
{
    uint8_t data_temp = 0;
    bitset<8> b(data_binary);
    unsigned char c = ( b.to_ulong() & 0xFF);
    data_temp = static_cast<uint8_t>(c);

    return data_temp;
}

uint8_t Get_Row(uint8_t key_id)
{
    uint8_t data_temp = 0;

    data_temp = key_id/(board_sum*8);

    return data_temp;
}

unsigned short Get_CRC_Modbus(byte data_byte[])
{
    unsigned short data_temp;

    data_temp = calculate_crc16_Modbus(reinterpret_cast<char*>(data_byte), 6);

    return data_temp;
}
byte to_send[6] = {0x00,0x03,0x14,0x15,0x01,0x00};
void Send_RS485(uint8_t board,uint8_t key_id,uint8_t key_id_blinking,bool Cek_Respon)
{
    to_send[0] = board+1;
    to_send[2] = key_id;
    to_send[3] = key_id_blinking;
    //printf("Calculating crc : ");
    unsigned short __crc = Get_CRC_Modbus(to_send);

    //printf("%02X\r\n",__crc);
    memcpy(buffer_crc,(unsigned char*)&(__crc),sizeof(short));
    byte _eof = 0x0D;

    byte all_to_send[9];

    all_to_send[0] = board+1;
    all_to_send[1] = to_send[1];
    all_to_send[2] = to_send[2];
    all_to_send[3] = to_send[3];
    all_to_send[4] = to_send[4];
    all_to_send[5] = to_send[5];
    all_to_send[6] = buffer_crc[1];
    all_to_send[7] = buffer_crc[0];
    all_to_send[8] = _eof;

Resend:

    printf("Data recv : ");
    for(uint8_t i = 0; i<15; i++) {
        printf("%02X ",respon_from_slave[i]);
    }
    printf("\r\n");
    wait(0.05);
    rede = 1;
    for(uint8_t i = 0; i<9; i++) {
        dv.putc(all_to_send[i]);
    }

    if(Cek_Respon) printf("Send Complete to %d\r\n",board+1);

    if(!Cek_Respon) {
        intr_Done = true;
    } else {
        //printf("Trying to received%d..\r\n",board+1);
        memset(respon_from_slave, 0, sizeof respon_from_slave);
        intr_Done = false;
        ids = 0;
        rede = 0;

        while(!intr_Done) {
            while(dv.readable()) {

                char tempbuf = dv.getc();
                if(ids == 0 && tempbuf == 0xFF) {

                } else {
                    respon_from_slave[ids] = tempbuf;
                    ids++;
                }
            }
            if((respon_from_slave[0] == board+1) && (respon_from_slave[14] == 0x0D)) intr_Done = true;
            else goto Resend;
        }
    }
}


void Cek_Ibutton()
{
    while(1) {
        ibutton.DetectiButton();
        if(ibutton.IsTaping())
            tap = true;
        else
            tap = false;

        if(tap != lasttap) {
            lasttap = tap;
            if(tap) {
                string dataButton;

                dataButton.clear();
                dataButton = ibutton.GetData();
                if(dataButton.length()== 12) {
                    ibutton_code = dataButton;
                    printf("[Data Button : %s]\r\n", dataButton.c_str());
                }
            }
        }
    }
}

void Cek_Salah_Buzzer()
{
    while(1) {
        if(real_blink_id_1 != 64 || real_blink_id_2 != 64 || real_blink_id_3 != 64 || real_blink_id_4 != 64|| real_blink_id_5 != 64) {
            buzz.play(3);
        }
        wait(0.2);
    }
}

void Cek_LCD_State()
{
    while(1) {

        if(LCD_Step == 0) {
            wait_ms(500);
            if((step == 0 || step == 4) && blinking_now != 0) {
                dsp.step5(to_string(blinking_now).c_str(),true);
                wait_ms(500);
                LCD_Step = 1;
            } else if(step == 0 && blinking_now == 0) {
                dsp.step0();
                LCD_Step = 1;
            } else if(step == 4 && blinking_now == 0) {
                dsp.step2(to_string(frm_data_received._key_id).c_str());
                LCD_Step = 1;
            }
        }
    }
}
string frames;
string First_Update()
{
    frames.clear();

    for(uint8_t i = 0; i<board_sum; i++) {
        wait_ms(50);
        intr_Done = false;
        ids = 0;
        bool done = false;
        waiting_resp = true;
        Send_RS485(i,64,64,true);

        for(uint8_t a = 4; a<12; a++) {
            uint8_t temp_id = a;
            switch(i) {
                case 0: {
                    Row_Board1_Last[temp_id-4] = respon_from_slave[a];
                    //printf("%02X\r\n",Row_Board1_Last[temp_id-5]);
                }
                break;
                case 1: {
                    Row_Board2_Last[temp_id-4] = respon_from_slave[a];
                    //printf("%02X\r\n",Row_Board2_Last[temp_id-5]);
                }
                break;
                case 2: {
                    Row_Board3_Last[temp_id-4] = respon_from_slave[a];
                    //printf("%02X\r\n",Row_Board3_Last[temp_id-5]);
                }
                break;
                case 3: {
                    Row_Board4_Last[temp_id-4] = respon_from_slave[a];
                    //printf("%02X\r\n",Row_Board4_Last[temp_id-5]);
                }
                break;
                case 4: {
                    Row_Board5_Last[temp_id-4] = respon_from_slave[a];
                    //printf("%02X\r\n",Row_Board5_Last[temp_id-5]);
                }
                break;
            }
        }
    }
    string bin_string;
    Frame_To_Send.ids = "";
    Frame_To_Send.key_off = "";
    Frame_To_Send.key_on = "";
    string key_ids;
    for (uint8_t i = 0; i < 5; i++) {
        for (uint8_t j = 0; j < 8; j++) {
            string bin_string = "";

            if (i == 0) bin_string =  Byte_to_StringBinary(Row_Board1_Last[j]);
            if (i == 1) bin_string =  Byte_to_StringBinary(Row_Board2_Last[j]);
            if (i == 2) bin_string =  Byte_to_StringBinary(Row_Board3_Last[j]);
            if (i == 3) bin_string =  Byte_to_StringBinary(Row_Board4_Last[j]);
            if (i == 4) bin_string =  Byte_to_StringBinary(Row_Board5_Last[j]);

            //printf("board[%d][%d] = %s\r\n",i,j,bin_string.c_str());
            for (uint8_t k = 0; k < 8; k++) {
                if (bin_string[abs(k-7)] == '1') {
                    key_ids = to_string((40*j)+k+(8*i)+1);
                    Frame_To_Send.key_on += (key_ids+"-");

                } else {
                    key_ids = to_string((40*j)+k+(8*i)+1);
                    Frame_To_Send.key_off += (key_ids+"-");
                }
            }
        }
    }

    if(Frame_To_Send.key_on == "") {
        Frame_To_Send.key_on = "0-";
    }

    if(Frame_To_Send.key_off == "") {
        Frame_To_Send.key_off = "0-";
    }
    Frame_To_Send.ids = "4";

    frames = Frame_To_Send.ids + ";" + Frame_To_Send.key_on + ";~";
    printf("Sent First Update : %s\r\n",frames.c_str());
    return frames;
}
string data_bin_pred;
void Make_Prediction(uint8_t board_numb,uint8_t baris, uint8_t kolom)
{
    printf("baris = %d\r\n",baris);
    printf("kolom = %d\r\n",kolom);

    memcpy(Row_Board1_Predict,Row_Board1_Last,sizeof(Row_Board1_Predict));
    memcpy(Row_Board2_Predict,Row_Board2_Last,sizeof(Row_Board2_Predict));
    memcpy(Row_Board3_Predict,Row_Board3_Last,sizeof(Row_Board3_Predict));
    memcpy(Row_Board4_Predict,Row_Board4_Last,sizeof(Row_Board4_Predict));
    memcpy(Row_Board5_Predict,Row_Board5_Last,sizeof(Row_Board5_Predict));

    board_numb += 1;
    if(board_numb == 1) {

        data_bin_pred.clear();
        data_bin_pred = Byte_to_StringBinary(Row_Board1_Predict[baris]);
        printf("%s\r\n",data_bin_pred.c_str());

        if(frm_data_received.cmd_id == 1) {
            data_bin_pred[abs(kolom-7)] = '0';
        } else if(frm_data_received.cmd_id == 2) {
            data_bin_pred[abs(kolom-7)] = '1';
        }

        Row_Board1_Predict[baris] = StringBinary_to_Byte(data_bin_pred.c_str());
    } else if(board_numb == 2) {

        data_bin_pred.clear();
        data_bin_pred = Byte_to_StringBinary(Row_Board2_Predict[baris]);
        printf("%s\r\n",data_bin_pred.c_str());

        if(frm_data_received.cmd_id == 1) {
            data_bin_pred[abs(kolom-7)] = '0';
        } else if(frm_data_received.cmd_id == 2) {
            data_bin_pred[abs(kolom-7)] = '1';
        }

        Row_Board2_Predict[baris] = StringBinary_to_Byte(data_bin_pred.c_str());
    } else if(board_numb == 3) {
        data_bin_pred.clear();
        data_bin_pred = Byte_to_StringBinary(Row_Board3_Predict[baris]);
        printf("%s\r\n",data_bin_pred.c_str());

        if(frm_data_received.cmd_id == 1) {
            data_bin_pred[abs(kolom-7)] = '0';
        } else if(frm_data_received.cmd_id == 2) {
            data_bin_pred[abs(kolom-7)] = '1';
        }

        Row_Board3_Predict[baris] = StringBinary_to_Byte(data_bin_pred.c_str());
    } else if(board_numb == 4) {
        data_bin_pred.clear();
        data_bin_pred = Byte_to_StringBinary(Row_Board4_Predict[baris]);
        printf("%s\r\n",data_bin_pred.c_str());

        if(frm_data_received.cmd_id == 1) {
            data_bin_pred[abs(kolom-7)] = '0';
        } else if(frm_data_received.cmd_id == 2) {
            data_bin_pred[abs(kolom-7)] = '1';
        }

        Row_Board4_Predict[baris] = StringBinary_to_Byte(data_bin_pred.c_str());
    } else if(board_numb == 5) {
        data_bin_pred.clear();
        data_bin_pred = Byte_to_StringBinary(Row_Board5_Predict[baris]);
        printf("%s\r\n",data_bin_pred.c_str());

        if(frm_data_received.cmd_id == 1) {
            data_bin_pred[abs(kolom-7)] = '0';
        } else if(frm_data_received.cmd_id == 2) {
            data_bin_pred[abs(kolom-7)] = '1';
        }

        Row_Board5_Predict[baris] = StringBinary_to_Byte(data_bin_pred.c_str());
    }
}