#ifndef _PRINTER_H_
#define _PRINTER_H_

#include "TMU220.h"
#include <string>
#include <vector>

// =============================================================================
class PrinterFormat
{
public:
    int id;
    string spbu;
    string telp;
    uint8_t first_nozle;
    int JumlahFillingPoint;
    vector<string> prodak;
    vector<string> alamat;
    vector<string> footer;
};

// =============================================================================
class ResultParsing
{
public:
    bool valid;
    uint8_t id;
    float volume;
    int money;
    int ppu;
    string product;
    uint8_t type;
};

// =============================================================================
class Printer
{
public:
    Printer(PinName tx_, PinName rx_, int baud_=9600);
    ~Printer();

    void init(const PrinterFormat &pf);

    void create_header();
    void TestPrint(const std::time_t &now);
    void PrintStruk(const std::time_t &now, const char *datain, const unsigned int &no_nota, const uint8_t &nozz,
                    const uint8_t pipa, const string &Nopol, const string &Odo);
    void PrintStruk(const std::time_t &now, const ResultParsing &res, const unsigned int &no_nota,
                    const string &Nopol, const string &Odo);
    void PrintStrukManual(const std::time_t &now, const ResultParsing &res, const unsigned int &no_nota);
    void DebugStruk(const std::time_t &now, const ResultParsing &res, const unsigned int &no_nota,
                    const string &Nopol, const string &Odo);
    void TestPrint2();

private:
    TMU220 Tm;
    PrinterFormat Pf;
    string get_product(const uint8_t code);
    static const char * const days[];
    static const char * const mons[];
};

#endif // _PRINTER_H_

