#include "mbed.h"
#include "Printer.h"

extern Serial dbg;
const char * const WDAY[] = {"Minggu", "Senin", "Selasa", "Rabu",
                             "Kamis", "Jumat", "Sabtu"
                            };
const char * const MONT[] = {"Januari", "Februari", "Maret", "April",
                             "Mei", "Juni", "Juli", "Agustus", "September",
                             "Oktober", "November", "Desember"
                            };

Printer::Printer(PinName tx_, PinName rx_, int baud_) : Tm(tx_, rx_)
{
}

Printer::~Printer()
{
}

void Printer::init(const PrinterFormat &pf)
{
    Pf = pf;
    //Tm.initialize();
}

void Printer::create_header()
{
    // create header
    Tm.putc(0x0A);
    wait_ms(10);
    Tm.printModes(0x00);
    wait_ms(10);
    Tm.printf("SPBU %s", Pf.spbu.c_str());
    wait_ms(10);
    //Tm.printModes(0x01);wait_ms(10);
    //Tm.printf("\n");wait_ms(10);
    Tm.putc(0x0A);
    wait_ms(10);
    for(int i=0; i<Pf.alamat.size(); i++) {
        Tm.printf("%s", Pf.alamat[i].c_str());
        wait_ms(10);
        Tm.putc(0x0A);
        wait_ms(10);
    }
    Tm.printf("Telp. %s", Pf.telp.c_str());
    wait_ms(10);
    Tm.putc(0x0A);
    wait_ms(10);
}

// Private Fuction
string Printer::get_product(const uint8_t code)
{
    string ret;
    switch(code) {
        case 1:
            ret = "Premium";
            break;
        case 2:
            ret = "Pertalite";
            break;
        case 3:
            ret = "Pertamax";
            break;
        case 4:
            ret = "Bio Solar";
            break;
        case 5:
            ret = "Pertamina Dex";
            break;
    }
    return ret;
}

void Printer::TestPrint(const std::time_t &now)
{
    std::tm * ptm = std::localtime(&now);
    char times[64];
    strftime (times,64,"%Y %H:%M:%S",ptm);

    Tm.printf("%s, %02d %s %s", WDAY[ptm->tm_wday], ptm->tm_mday, MONT[ptm->tm_mon], times);
    Tm.putc(0x0A);
    Tm.printf("__________________________________");
    Tm.putc(0x0A);
    Tm.printf("Nomor Printer: %d", Pf.id);
    Tm.putc(0x0A);
    Tm.printf("Nomor Selang : 2");
    Tm.putc(0x0A);
    Tm.printf("Nomor Nota   : 1");
    Tm.putc(0x0A);
    Tm.printf("Jenis BBM    : SOLAR");
    Tm.putc(0x0A);
    Tm.printf("Liter        : 5.00");
    Tm.putc(0x0A);
    Tm.printf("Harga/Liter  : Rp 10.000");
    Tm.putc(0x0A);
    Tm.printModes(0x10);
    Tm.printf("Total        : Rp 50.000");

    Tm.printModes(0x01);
    Tm.printf("_________________________________\n");
    //for(int i=0; i<Pf.footer.size(); i++) {
//        Tm.printf("%s\r\n", Pf.footer[i].c_str());
//    }
    Tm.printf("\n");
    Tm.printf("\n");
    Tm.printf("\n");
    Tm.printf("\n");
    Tm.printf("\n");

    create_header();
}
string intwcurrency(const int &val)
{
    char str[20];

    sprintf(str,"%6d", val);
    string input;
    input += str;
    if(val>999) {
        for( int i = input.size() - 3; i > 0; i -= 3 ) {
            input.insert(  input.begin() + i, ',' );
        }
    } else {
        for( int i = input.size() - 3; i > 0; i -= 3 ) {
            input.insert(  input.begin() + i, ' ' );
        }
    }
    return input;
}

void Printer::PrintStruk(const std::time_t &now, const char *datain, const unsigned int &no_nota, const uint8_t &nozz,
                         const uint8_t pipa, const string &Nopol, const string &Odo)
{
    float liter=0;
    unsigned int harga=0;
    unsigned long int total=0;
    char times[64];


    liter =((datain[1]-0x30)*100) + ((datain[2]-0x30)*10) + ((datain[3]-0x30)*1) + ((datain[4]-0x30)*0.1) + ((datain[5]-0x30)* 0.01);

    harga = ((datain[7]-0x30)*1000) + ((datain[8]-0x30)*100) + ((datain[9]-0x30)*10) + ((datain[10]-0x30)*1);
    total = ((datain[11]-0x30)*100000) + ((datain[12]-0x30)*10000) + ((datain[13]-0x30)*1000) + ((datain[14]-0x30)*100) + ((datain[15]-0x30)*10)+((datain[16]-0x30)*1);

    if(Pf.id == 2 || Pf.id == 3 || Pf.id == 5) {
        harga = harga/10;
        total = total/10;
    }

    std::tm * ptm = std::localtime(&now);
    strftime (times,64,"%Y %H:%M:%S",ptm);
    wait_ms(100);

    Tm.printf("%s, %02d %s %s", WDAY[ptm->tm_wday], ptm->tm_mday, MONT[ptm->tm_mon], times);
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printf("__________________________________");
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
//    Tm.printf("Nomor Printer: %d", Pf.id);
//    wait_ms(10);
//    Tm.lineFeed();
//    wait_ms(10);
    Tm.printf("Nomor Selang : %d", pipa);
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printf("Nomor Nota   : %d", no_nota);
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printf("Jenis BBM    : %s", get_product(nozz).c_str());
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printf("Liter        : %3.2f",liter);
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printf("Harga/Liter  : Rp. %s",intwcurrency(harga).c_str());
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printModes(0x10);
    wait_ms(10);
    Tm.printf("Total        : Rp. %s",intwcurrency(total).c_str());
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printModes(0x00);
    wait_ms(10);
    Tm.printf("__________________________________");
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);

    if(Nopol.size()>0)Tm.printf("Nopol        : %s",Nopol.c_str());
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);

    if(Odo.size()>0)  Tm.printf("Odometer     : %s",Odo.c_str());
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);

    wait_ms(50);
//    for(int i=0; i<Pf.footer.size(); i++) {
//        Tm.printf("%s\r", Pf.footer[i].c_str());
//        wait_ms(10);
//        Tm.lineFeed();
//        wait_ms(10);
//    }
    Tm.lineFeed();
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.cutPaper();
    create_header();
}

void Printer::PrintStruk(const std::time_t &now, const ResultParsing &res, const unsigned int &no_nota,
                         const string &Nopol, const string &Odo)
{
    float liter=0;
    unsigned int harga=0;
    unsigned long int total=0;
    char times[64];
    liter = res.volume;
    harga = res.ppu;
    total = res.money;

    if(res.id == 2 || res.id == 5) {
        harga = harga/10;
        total = total/10;
    }
    std::tm * ptm = std::localtime(&now);
    strftime (times,64,"%Y %H:%M:%S",ptm);
    wait_ms(100);

    Tm.printf("%s, %02d %s %s", WDAY[ptm->tm_wday], ptm->tm_mday, MONT[ptm->tm_mon], times);
    wait_ms(30);
    printf("time printed\r\n");
    Tm.lineFeed();
    wait_ms(30);
    Tm.printf("__________________________________");
    printf("line printed\r\n");
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
//    Tm.printf("Nomor Printer: %d", Pf.id);
//    wait_ms(10);
//    Tm.lineFeed();
//    wait_ms(10);
    Tm.printf("Nomor Selang : %d", res.id);
    printf("Selang printed\r\n");

    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.printf("Nomor Nota   : %d", no_nota);
    printf("Nomor Nota printed\r\n");
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.printf("Jenis BBM    : %s", res.product.c_str());
    printf("Jenis BBM printed\r\n");
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.printf("Liter        : %3.2f",liter);
    printf("Liter printed\r\n");
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.printf("Harga/Liter  : Rp. %s",intwcurrency(harga).c_str());
    printf("Harga/Liter printed\r\n");
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.printModes(0x10);
    wait_ms(30);
    Tm.printf("Total        : Rp. %s",intwcurrency(total).c_str());
    printf("Total printed\r\n");
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.printModes(0x00);
    wait_ms(30);
    Tm.printf("__________________________________");
    printf("Line printed\r\n");
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);

    if(Nopol.size()>0) {
        Tm.printf("Nopol        : %s",Nopol.c_str());
        wait_ms(30);
        Tm.lineFeed();
        wait_ms(30);
    }

    if(Odo.size()>0) {
        Tm.printf("Odometer     : %s",Odo.c_str());
        wait_ms(30);
        Tm.lineFeed();
        wait_ms(30);
    }

    if(Nopol.size()>0 && Odo.size() >0) {
        Tm.printf("==================================");
        wait_ms(30);
        Tm.lineFeed();
        wait_ms(30);
    }
    printf("Line printed\r\n");
    wait_ms(50);
//    for(int i=0; i<Pf.footer.size(); i++) {
//        Tm.printf("%s", Pf.footer[i].c_str());
//        wait_ms(10);
//        Tm.lineFeed();
//        wait_ms(10);
//    }
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.lineFeed();
    wait_ms(30);
    Tm.cutPaper();
    wait_ms(50);
    create_header();
    wait_ms(30);
    printf("Done\r\n");
}

void Printer::PrintStrukManual(const std::time_t &now, const ResultParsing &res, const unsigned int &no_nota)
{
    float liter=0;
    unsigned int harga=0;
    unsigned long int total=0;
    char times[64];

    liter = res.volume;
    harga = res.ppu;
    total = res.money;

    if(res.id == 2 || res.id == 5) {
        harga = harga/10;
        total = total/10;

    }

    std::tm * ptm = std::localtime(&now);
    strftime (times,64,"%Y %H:%M:%S",ptm);
    wait_ms(100);

    Tm.printf("%s, %02d %s %s", WDAY[ptm->tm_wday], ptm->tm_mday, MONT[ptm->tm_mon], times);
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printf("__________________________________");
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printf("Nomor Printer: %d", Pf.id);
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
//    Tm.printf("Nomor Selang : %d", res.id);
//    wait_ms(10);
//    Tm.lineFeed();
//    wait_ms(10);
    Tm.printf("Nomor Nota   : %d", no_nota);
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printf("Jenis BBM    : %s", res.product.c_str());
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printf("Liter        : %3.2f",liter);
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printf("Harga/Liter  : Rp. %s",intwcurrency(harga).c_str());
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.printModes(0x10);
    wait_ms(10);
    Tm.printf("Total        : Rp. %s\n",intwcurrency(total).c_str());
    wait_ms(10);
    Tm.printModes(0x00);
    wait_ms(10);
    Tm.printf("_________________________________");
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    wait_ms(50);
//    for(int i=0; i<Pf.footer.size(); i++) {
//        Tm.printf("%s", Pf.footer[i].c_str());
//        wait_ms(10);
//        Tm.lineFeed();
//        wait_ms(10);
//    }
    Tm.lineFeed();
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.lineFeed();
    wait_ms(10);
    Tm.cutPaper();
    create_header();
}

void Printer::DebugStruk(const std::time_t &now, const ResultParsing &res, const unsigned int &no_nota,
                         const string &Nopol, const string &Odo)
{
    float liter=0;
    unsigned int harga=0;
    unsigned long int total=0;
    char times[64];

    liter = res.volume;
    harga = res.ppu;
    total = res.money;

    std::tm * ptm = std::localtime(&now);
    strftime (times,64,"%Y %H:%M:%S",ptm);
    wait_ms(100);

    dbg.printf("%s, %02d %s %s\n\r", WDAY[ptm->tm_wday], ptm->tm_mday, MONT[ptm->tm_mon], times);
    dbg.printf("__________________________________\n\r");
    dbg.printf("Nomor Printer: %d\n\r", Pf.id);
    dbg.printf("Nomor Selang : %d\n\r", res.id);
    dbg.printf("Nomor Nota   : %d\n\r", no_nota);
    dbg.printf("Jenis BBM    : %s\n\r", res.product.c_str());
    dbg.printf("Liter        : %3.2f\n\r",liter);
    dbg.printf("Harga/Liter  : Rp. %s\n\r",intwcurrency(harga).c_str());
    dbg.printf("Total        : Rp. %s\n\r",intwcurrency(total).c_str());
    dbg.printf("_________________________________\n\r");

    if(Nopol.size()>0)dbg.printf("Nopol        : %s\n\r",Nopol.c_str());
    if(Odo.size()>0)  dbg.printf("Odometer     : %s\n\r",Odo.c_str());

    wait_ms(50);
//    for(int i=0; i<Pf.footer.size(); i++) {
//        dbg.printf("%s\r\n", Pf.footer[i].c_str());
//    }
    dbg.printf("\n\n\r");
}

void Printer::TestPrint2()
{
    create_header();
    Tm.printf("_________________________________");
    wait_ms(10);
    Tm.lineFeed();
    for(int i=0; i<Pf.prodak.size(); i++) {
        Tm.printf("Produk %d : %s",i+1, Pf.prodak[i].c_str());
        wait_ms(10);
        Tm.lineFeed();
        wait_ms(10);
    }
    Tm.printf("_________________________________");
    Tm.putc(0x0A);
    Tm.putc(0x0A);
    Tm.putc(0x0A);
    Tm.putc(0x0A);
    Tm.cutPaper();
}
