#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include "MbedJSONValue.h"
#include <sstream>
#include <iostream>
#include <fstream>

#define IP_CONF_PORT 50004

#define ijo 0
#define merah 1

UDPSocket sock, ip_conf, trx_ser; //gen_con,
Endpoint multi, server; //,multi_data;

SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");

DigitalOut Stdby_R(LED2), Sopir_R(LED3), Res_R(LED1), MT_R(LED4), Gate(PTB9), Sleep(PTA1), Reset(PTB23, 1);
DigitalInOut Std_G(PTC5), Std_R(PTC7), Spr_G(PTC0), Spr_R(PTC9), Mt_G(PTC8), Mt_R(PTC1), Pow(PTB19), iBtn(PTB18);
DigitalIn print_er(PTC2), print_done(PTB2);

Serial dbg(USBTX, USBRX);
Serial pc(PTC17, PTC16);

char IP[16], SUBNET[16], GATEWAY[16], MCAST[16], IDX[5];
int PortListen, PortSend, PortHeartB;
int BAUD = 19200;

int width, TICK = 0;
unsigned char ID[8], idx, idy, id_addr = 0x33, ix, er_tmp1 = 0, er_tmp2 = 0,
        sprmt = 0; // state = 1,
char text[26], ch, rx_buff[6], tx_buff[7],  //86
        _hex[17] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B',
                'C', 'D', 'E', 'F' };  //,

/*Contoh format data
 <02>GI01S0123456789ABCDEF00<03>
 <02>GI01M0123456789ABCDEF00<03>
 <02> ->start
 GI -> Lokasi <G = Gate> <I = Input> <O = Output>
 01 -> ID
 S -> Supir <S = Supir> <M = MT>
 0123456789ABCDEF -> iButton data
 00 -> reserved
 <03> -> stop

 format heartbeat
 <02>GI0100000000<03>

 format validasi
 <02>V01<03>
 1, idle
 2, stdby/ idle
 3, merah/sopir
 4, biru/ MT
 5, buka gate

 format ipconfig
 <02> 192.168.1.116, 255.255.255.0, 192.168.1.1, 192.168.1.10, 50000, 50001, 50003, GI01$<03>
 #192.168.1.116, 255.255.255.0, 192.168.1.1, 192.168.1.10, 50000, 50001, 50003, GI01$
 2, stdby
 3, merah/sopir
 4, biru MT
 */

void Standby(bool warna, bool nyala) {
    switch (nyala) {
    case 0:
        if (warna == ijo) {
            Stdby_R = 0;    // led 2
            Std_G.output();
            Std_G.write(0);
            Std_G.input();
            Std_G.mode(PullUp);
        } else if (warna == merah) {
            Std_R.output();
            Std_R.write(0);
            Std_R.input();
            Std_R.mode(PullUp);
        }
        break;
    case 1:
        if (warna == ijo) {
            Stdby_R = 1;
            Std_G.output();
            Std_G.write(1);
        } else if (warna == merah) {
            Std_R.output();
            Std_R.write(1);
        }
        break;
    }
}

void Sopir(bool warna, bool nyala) {
    switch (nyala) {
    case 0:
        if (warna == ijo) {
            Sopir_R = 0;    // led 3
            Spr_G.output();
            Spr_G.write(0);
            Spr_G.input();
            Spr_G.mode(PullUp);
        } else if (warna == merah) {
            Spr_R.output();
            Spr_R.write(0);
            Spr_R.input();
            Spr_R.mode(PullUp);
        }
        break;
    case 1:
        if (warna == ijo) {
            Sopir_R = 1;
            Spr_G.output();
            Spr_G.write(1);
        } else if (warna == merah) {
            Spr_R.output();
            Spr_R.write(1);
        }
        break;
    }
}

void eMTy(bool warna, bool nyala) {
    switch (nyala) {
    case 0:
        if (warna == ijo) {
            MT_R = 0;       // led 4
            Mt_G.output();
            Mt_G.write(0);
            Mt_G.input();
            Mt_G.mode(PullUp);
        } else if (warna == merah) {
            Mt_R.output();
            Mt_R.write(0);
            Mt_R.input();
            Mt_R.mode(PullUp);
        }
        break;
    case 1:
        if (warna == ijo) {
            MT_R = 1;
            Mt_G.output();
            Mt_G.write(1);
        } else if (warna == merah) {
            Mt_R.output();
            Mt_R.write(1);
        }
        break;
    }
}

string open_file(const char *location)
{
    string rtn = "\0";
    
//    dbg.printf("OPEN FILE %s\r\n", location);
    ifstream stream(location, std::ifstream::binary);
    
    if ( !stream.is_open() ) {
        dbg.printf("File Opening Error\n\r");
        stream.close();
    }
    else
    {
        stream.seekg(0,stream.end);
        int len = stream.tellg();
        stream.seekg(0,stream.beg);
        
        char *_stream = new char [len];
        
        stream.read(_stream,len);
        _stream[len] = '\0';
        
        rtn += _stream;
        stream.close();
        delete [] _stream;
    }
    
    return rtn;
}

bool mbed_config_init()
{
    dbg.printf("Masuk mbed config init\r\n");
    
    MbedJSONValue config_json;
    string dataSet = open_file("/sd/IPCONF.TXT");
    dbg.printf("isi file :\r\n%s\r\n", dataSet.c_str());
    
    if(dataSet.size() > 1)
    {
        string err;
        parse(config_json, dataSet.c_str(), dataSet.c_str() + strlen(dataSet.c_str()), &err);
        if(err.size() > 0)
        {
            dbg.printf("res error? %s\r\n", err.c_str());
            return false;
        }   
        else
        {
            const char *ip_temp      = config_json["IP"].get<string>().c_str();
            const char *sub_temp     = config_json["SUBNET"].get<string>().c_str();
            const char *gate_temp    = config_json["GATEWAY"].get<string>().c_str();
            const char *mcast_temp   = config_json["MCAST"].get<string>().c_str();
            const char *idx_temp     = config_json["IDX"].get<string>().c_str();
            PortListen  = config_json["PortListen"].get<int>();
            PortSend    = config_json["PortSend"].get<int>();
            PortHeartB   = config_json["PortHeartBit"].get<int>();
            BAUD        = config_json["BAUD"].get<int>();
            
            sprintf(IP,"%s", ip_temp);
            sprintf(SUBNET, "%s", sub_temp);
            sprintf(GATEWAY, "%s", gate_temp);
            sprintf(MCAST, "%s", mcast_temp);
            sprintf(IDX, "%s", idx_temp);
            
            dbg.printf("IP Device         = %s\r\n", IP);
            dbg.printf("Subnet            = %s\r\n", SUBNET);
            dbg.printf("Gateway           = %s\r\n", GATEWAY);
            dbg.printf("Multicast IP      = %s\r\n", MCAST);
            dbg.printf("Server to mBed    = %d\r\n", PortListen);
            dbg.printf("mBed to Multicast = %d\r\n", PortSend);
            dbg.printf("HeartBeat Port    = %d\r\n", PortHeartB);
            dbg.printf("device IDX        = %s\r\n", IDX);
            dbg.printf("Serial Baudrate   = %d\r\n", BAUD);
            
            return true;
        }
    }
    else
    {
        dbg.printf("Config is not found\r\n");
        return false;
    }
}

unsigned char reset(void) {
    for (idx = 0; idx < 8; idx++) {
        ID[idx] = 0;
    }
    ix = 0;
    iBtn.output();
    iBtn.write(0);
    wait_us(480);
    iBtn.write(1);
    iBtn.mode(PullUp);
    iBtn.input();

    for (int i = 0; i < 180; i++) {
        wait_us(1);
        if (iBtn == 0) {
            ix = 1;
        }
    }
    wait_us(1);
    if (ix == 0) {
        return 0;
    } else
        return 1;
}

int write() {
    iBtn.output();
    iBtn.write(1);
    for (idx = 0; idx < 8; idx++) {
        for (int i = 0; i < 35; i++) {
            wait_us(1);
            if (i >= 2) {
                iBtn.write((id_addr >> idx) & 1);
            } else
                iBtn.write(0);
        }
        iBtn.write(1);
    }
    wait_us(2);
    return 0;
}

int read() {
    iBtn.output();
    iBtn.write(1);
    for (idx = 0; idx < 8; idx++) {
        for (idy = 0; idy < 8; idy++) {
            width = 0;
            iBtn.output();
            iBtn.write(0);
            wait_us(1);
            iBtn.input();
            for (int i = 0; i < 35; i++) {
                wait_us(1);
                if (iBtn.read()) {
                    width++;
                }
            }
            if (width > 25) {
                ID[idx] |= (1 << idy);
            }
        }
    }

    for (idx = 0; idx < 8; idx++) {
        text[((7 - idx) * 2) + 7] = _hex[ID[idx] & 0x0f];
        text[((7 - idx) * 2) + 6] = _hex[(ID[idx] >> 4) & 0x0f];
    }
    string str;
    size_t found1;
    str += text;
        
    found1 = str.find("FFFFFFFFFF");
    if(found1 == std::string::npos)
    {
        found1 = str.find("000000000000");
        if(found1 == std::string::npos)
        {
            dbg.printf(text);
            dbg.printf("\r\n");
        }
    }
    return 0;
}

int cmpstr(const char *str, const char *sub) {
    int length = strlen(sub);
    if (length == 0)
        return 0;
    int count = 0;
    for (str = strstr(str, sub); str; str = strstr(str + length, sub))
        ++count;
    return count;
}

void Hartbit(unsigned char std) {
    char hb_buff[20], hb_num[10];
    static int hb;
    hb_buff[0] = IDX[0];
    hb_buff[1] = IDX[1];
    hb_buff[2] = IDX[2];
    hb_buff[3] = IDX[3];

    multi.set_address(MCAST, PortHeartB);
    hb++;

    switch (std) {
    case 0:
        //Standby(0, 1);
        if (hb < 375) {
            Sopir(0, 1);
        } else if ((hb >= 375) && (hb < 750)) {
            Sopir(0, 0);
        } else if ((hb >= 750) && (hb < 1125)) {
            Sopir(0, 1);
        } else if ((hb >= 1125) && (hb < 1500))
            Sopir(0, 0);
        if (hb >= 1500) {
            sprintf(hb_num, "%d", TICK);
            strcat(hb_buff, hb_num);
            sock.sendTo(multi, hb_buff, sizeof(hb_buff));
            hb = 0;
            TICK++;
        }
        break;
    case 1:
        Standby(0, 0);
        Standby(0, 1);
        if (hb < 750) {
            Standby(0, 1);
        } else if ((hb >= 750) && (hb < 1500)) {
            Standby(0, 0);
        } else if ((hb >= 1500) && (hb < 2250)) {
            Standby(0, 1);
        } else if ((hb >= 2250) && (hb < 3000))
            Standby(0, 0);
        if (hb >= 3000) {
            sprintf(hb_num, "%d", TICK);
            strcat(hb_buff, hb_num);
            sock.sendTo(multi, hb_buff, sizeof(hb_buff));
            hb = 0;
            TICK++;
        }

        break;
    case 2:
        Standby(0, 1);
        if (hb >= 7000) {
            sprintf(hb_num, "%d", TICK);
            strcat(hb_buff, hb_num);
            sock.sendTo(multi, hb_buff, sizeof(hb_buff));
            hb = 0;
            TICK++;
        }
        break;
    }
}

int openForce() {
    int n = sock.receiveFrom(server, rx_buff, sizeof(rx_buff));
    
    if (n != 0) {
        if ((rx_buff[1] == 'V') && (rx_buff[3] == '5')) {
            eMTy(0, 0);
            Sopir(0, 0);
            wait(1);
            Gate = 1;                                                   //BYPASS
            wait_ms(1500);                                              //BYPASS
            Gate = 0;                                                   //BYPASS
            sprmt = 0;
            tx_buff[4] = 'P';
            tx_buff[5] = '0';
            tx_buff[6] = '0';
            multi.set_address(MCAST, PortSend);
            sock.sendTo(multi, tx_buff, sizeof(tx_buff));
        } else if (rx_buff[1] == 'R') {
            tx_buff[4] = 'P';
            tx_buff[5] = '0';
            tx_buff[6] = '0';
            sprmt = 0;
            multi.set_address(MCAST, PortSend);
            sock.sendTo(multi, tx_buff, sizeof(tx_buff));
            eMTy(0, 0);
            Sopir(0, 0);
            Gate = 0;
        }
    } else {
        return 0;
    }
    return 0;
}

int set_IP() {
    char ptr_data;
    //server.set_address(SERVER,ER_SEND_PORT);
    //char print_rx_buff[128];
//    char conf_buff[1024] = { 0 }, print_init[20] = { 0x1b, 0x40, 0x1b, 0x54,
//            0x1b/*,0x57*/, 0x00, 0x1b, 0x77, 0x00, 0x12, 0x1b, 0x43, 0x00, 0x06,
//            0x1b, 0x6c, 0x01, 0x12 };
    char conf_buff[1024] = { 0 };
    int n = ip_conf.receiveFrom(server, conf_buff, sizeof(conf_buff));
    if (n >= 0) {
        //printf("Packet from \"%s\": %s\n", server.get_address(), conf_buff);
        if (conf_buff[0] == '^') {
            if (conf_buff[1] == 'R') {
                Reset = 0;
            } else if (conf_buff[1] == 'S') {
                Sleep = 1;
                Gate = 0;
                
                int stop = 0;
                while(stop != 1)
                {
                    Spr_G.input();
                    Spr_G.mode(PullUp);
                    
                    Mt_G.input();
                    Mt_G.mode(PullUp);
                    
                    Std_G.input();
                    Std_G.mode(PullUp);
                    
                    ip_conf.receiveFrom(server, conf_buff, sizeof(conf_buff));
                    
                    if (conf_buff[0] == '^') 
                    {
                        if (conf_buff[1] == 'W')
                        {
                            stop = 1;
                            Sleep = 0;
                        }
                        else if (conf_buff[1] == 'R')
                        {
                            stop = 0;
                        }
                        else if (conf_buff[1] == 'S')
                        {
                            stop = 0;
                        }
                        else stop = 0;
                    }
                    else if (conf_buff[0] == '2') stop = 0;
                    
                    else stop = 0;
                }
                //sock.close(true);
            } else if (conf_buff[1] == 'W') {
                Sleep = 0;
                //sock.bind(PortListen);
            }
        } else if (conf_buff[0] == 0x0f) {
            //dbg.printf("%s", print_init);
            pc.printf("%s", conf_buff);
            ptr_data = *strchr(conf_buff, 0x1d);
            if (ptr_data != NULL) {
                tx_buff[4] = 'D';
                tx_buff[5] = '0';
                tx_buff[6] = '1';
                multi.set_address(MCAST, PortSend);
                sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                dbg.printf("Printer Done\r\n");
            }
        } else
            return 0;
    } else {
        return 0;
    }
    return 0;
}

void flush(void)
{
    int chk;
    do
    {
        char flush_buff[1024] = { 0 };
        chk = ip_conf.receiveFrom(server, flush_buff, sizeof(flush_buff));
        //clear flush_buff
        for(int i = 0; i <sizeof(flush_buff); i++)
        {
            flush_buff[i] = '\0';
        }
    }while (chk > 0);
}

void Set_IP_Manual()
{
    sprintf(IP,"192.168.0.101");
    sprintf(SUBNET, "255.255.255.0");
    sprintf(GATEWAY, "192.168.0.1");
    sprintf(MCAST, "224.1.1.8");
    PortListen = 50007;
    PortSend = 50001;
    PortHeartB = 50003;
    sprintf(IDX, "GO01");
    BAUD = 38400;
    
    dbg.printf("IP Device         = %s\r\n", IP);
    dbg.printf("Subnet            = %s\r\n", SUBNET);
    dbg.printf("Gateway           = %s\r\n", GATEWAY);
    dbg.printf("Multicast IP      = %s\r\n", MCAST);
    dbg.printf("Server to mBed    = %s\r\n", PortListen);
    dbg.printf("mBed to Multicast = %s\r\n", PortSend);
    dbg.printf("HeartBeat Port    = %s\r\n", PortHeartB);
    dbg.printf("device IDX        = %s\r\n", IDX);
}

int main(void) {
    mkdir("/sd/", 0777);
    
    bool card_ready = mbed_config_init(); // Digunakan jika setting ip melalui micro sd
    if(!card_ready)
    {
        dbg.printf("Set Config via hard code\r\n");
        Set_IP_Manual(); // Digunakan jika setting ip secara manual
    }
    
    dbg.printf("Printer Baud = %d\r\n",BAUD);
    pc.baud(BAUD);
    dbg.baud(9600);
    dbg.printf("System Start \r\n");

    EthernetInterface eth;
    eth.init(IP, SUBNET, GATEWAY);
    int n = eth.connect();
    if (!n) {
        dbg.printf("Ethernet is not connect");
    } else
        dbg.printf("Ethernet is connect");
    
    ip_conf.bind(IP_CONF_PORT);
    ip_conf.set_blocking(false, 0);
    server.set_address(MCAST, 50002);

    sock.bind(PortListen);

    sock.set_blocking(false, 0);

    text[0] = 2;
    text[1] = IDX[0];
    text[2] = IDX[1];
    text[3] = IDX[2];
    text[4] = IDX[3];
    text[22] = '0';
    text[23] = '0';
    text[24] = 3;
    unsigned char tmp, sndrcv = 0, tmpx = 0;
    int timeout = 0;
    
    dbg.printf("Device Ready\r\n");

    tx_buff[0] = IDX[0];
    tx_buff[1] = IDX[1];
    tx_buff[2] = IDX[2];
    tx_buff[3] = IDX[3];
    tx_buff[4] = 'R';
    tx_buff[5] = '0';
    
    multi.set_address(MCAST, PortSend);
    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
    
    eMTy(ijo, 0);
    eMTy(merah, 0);
    Sopir(ijo, 0);
    Sopir(merah, 0);
    Standby(ijo, 0);
    Standby(merah, 0);
    Res_R = 1;
    
    flush(); // clear ethernet port
    
    while (true) {
        for (idx = 0; idx < 6; idx++) {
            rx_buff[idx] = 0;
        }

        switch (sndrcv) {
        case 0: {
            tmp = reset();

            if (tmp == 1) {
                if (tmpx == 0) {
                    if (sprmt == 0) {
                        Sopir(0, 1);
                    } else {
                        eMTy(0, 1);
                    }
                    wait_ms(70);
                    reset();
                    write();
                    read();
                    if (sprmt == 0) {
                        Sopir(0, 0);
                        text[5] = 'S';
                    } else {
                        eMTy(0, 0);
                        text[5] = 'M';
                    }
                    if (cmpstr(text, "F") < 10) {
                        multi.set_address(MCAST, PortSend);
                        sock.sendTo(multi, text, sizeof(text));
                        sndrcv = 1;
                    }
                }
            }

            if (sprmt == 0) {
                if (sndrcv == 1) {
                    Hartbit(2);
                } else
                    Hartbit(1);
            } else if (sprmt == 1)
                Hartbit(0);

            tmpx = tmp;
            openForce();
            break;
        }
        case 1: {
            sock.bind(PortListen);
            
            int n = sock.receiveFrom(server, rx_buff, sizeof(rx_buff));
            if (n != 0) {
                dbg.printf("Packet from \"%s\": %s\n", server.get_address(),
                        rx_buff);
                if ((rx_buff[1] == 'V') && (rx_buff[3] == '3')) {
                    sndrcv = 0;
                    Sopir(0, 1);
                    sprmt = 1;
                    tx_buff[4] = 'O';
                    tx_buff[5] = 'K';
                    tx_buff[6] = '!';
                    multi.set_address(MCAST, PortSend);
                    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                    dbg.printf("Data S Valid..\r\n");
                } else if ((rx_buff[1] == 'A') && (rx_buff[3] == '3')) {
                    sndrcv = 0;
                    Sopir(0, 0);
                    eMTy(0, 1);
                    wait_ms(200);
                    eMTy(0, 0);
                    sprmt = 0;
                    tx_buff[4] = 'O';
                    tx_buff[5] = 'K';
                    tx_buff[6] = '!';
                    multi.set_address(MCAST, PortSend);
                    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                    dbg.printf("Data S Not Valid, but M valid, reset!!!!\r\n");
                } else if ((rx_buff[1] == 'V') && (rx_buff[3] == '4')) {
                    Sopir(0, 1);
                    eMTy(0, 1);
                    wait_ms(500);
                            /*
                                Lakukan perubahan disini menyangkut dengan:
                                    - delay lebih lama
                                    - sprmt yang ditambah
                            */
                    tx_buff[4] = 'O';
                    tx_buff[5] = 'K';
                    tx_buff[6] = '!';
                    multi.set_address(MCAST, PortSend);
                    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                    dbg.printf("Data M Valid..\r\n");
                } else if ((rx_buff[1] == 'A') && (rx_buff[3] == '4')) {
                    sndrcv = 0;
                    if (sprmt == 0) {
                        Sopir(0, 0);
                    } else {
                        Sopir(0, 1);
                    }
                    eMTy(0, 0);
                    tx_buff[4] = 'O';
                    tx_buff[5] = 'K';
                    tx_buff[6] = '!';
                    multi.set_address(MCAST, PortSend);
                    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                    dbg.printf("Data M Not Valid, refresh!!!!\r\n");
                } else if (rx_buff[1] == 'R') {
                    sndrcv = 0;
                    Sopir(0, 0);
                    eMTy(0, 0);
                    sprmt = 0;
                    tx_buff[4] = 'O';
                    tx_buff[5] = 'K';
                    tx_buff[6] = '!';
                    multi.set_address(MCAST, PortSend);
                    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                    dbg.printf("All Data Not Valid, reset!!!!\r\n");
                }
            } else {
                timeout++;
                if (timeout >= 12000) {
                    sndrcv = 0;
                    timeout = 0;
                }
            }
            Stdby_R = 1;
            openForce();
            break;
            }
        }
        
        // membaca perintah dari server dari port 5004
        set_IP();
        
        // cek printer
        if (!print_er) {
            er_tmp2 = 0;
            if (er_tmp1 < 3) {
                tx_buff[4] = 'X';
                tx_buff[5] = '0';
                tx_buff[6] = '1';
                multi.set_address(MCAST, PortSend);
                dbg.printf("Printer Error\r\n");
                sock.sendTo(multi, tx_buff, sizeof(tx_buff));
            } else
                er_tmp1 = 5;
            er_tmp1++;
        } else if (print_er) {
            er_tmp1 = 0;
            if (er_tmp2 < 3) {
                tx_buff[4] = 'N';
                tx_buff[5] = '0';
                tx_buff[6] = '1';
                dbg.printf("Printer Fixed\r\n");
                multi.set_address(MCAST, PortSend);
                sock.sendTo(multi, tx_buff, sizeof(tx_buff));
            } else
                er_tmp2 = 5;
            er_tmp2++;
        }
    }
}