#ifndef DISPLAYS_H
#define DISPLAYS_H

#include "mbed.h"
#include "Noritake.h"
#include <sstream>
#include <iostream>
#include <fstream>
#include <stdarg.h>
#include <vector>

class Displays
{
public:
    void init();
    void displayTime(time_t &dt);
    void displayCmd(const char* msg);
    void header();
    string Convertint(int data);
    void step0();
    void step1(bool c);
    void step2(const char *str);
    void step3(std::vector<string> vecBuf);
    void step4(const char *str, bool muncul=false);
    void step5(const char *str, bool muncul=true);
    void displaybtn(const char *_ibtn);
    void error(const int &c);
    
    Displays(PinName TX, PinName RX);
    ~Displays();
private:
    PinName tx;
    PinName rx;
    void writePort(uint8_t data);
    void hardReset();
};

#endif