#include "mbed.h"
#include "Displays.h"
#include "SoftSerial.h"

//extern std::string ibuttondsp;

Displays::Displays(PinName TX, PinName RX):tx(TX), rx(RX)
{

}

Displays::~Displays()
{

}

string Displays::Convertint(int data)
{
    std::stringstream c;
    c << data;
    return c.str();
}

void Displays::init()
{
    Noritake *vfd = new Noritake(tx, rx);
    vfd->GU7000_cursorOff();
    vfd->GU7000_clearScreen();
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_setFontSize(1,1,false);
    vfd->printat(30, 15, "Selamat Datang");
    vfd->printat(25, 30, "Mencari Server.... ");
    vfd->GU7000_setFontSize(1, 1, false);
    delete vfd;
}

void Displays::header()
{
    Noritake *vfd = new Noritake(tx, rx);
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_clearScreen();
    vfd->printat(0, 0, "  <=< LOCKER KEY >=>");
    delete vfd;
}

void Displays::displayTime(time_t &dt)
{
    char buf1[20];
    strftime(buf1,20,"%d/%m/%Y %H:%M", localtime(&dt));
//    vfd.GU7000_setCursor(0,56);
//    vfd.print(buf1);
}

void Displays::displayCmd(const char* msg)
{
    char buffer[64];
    sprintf (buffer,"%s",msg);
//    vfd.GU7000_setCursor(0,32);
//    vfd.print(buffer);
}

void Displays::step0()
{
    Noritake *vfd = new Noritake(tx, rx);
    vfd->GU7000_clearScreen();
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_setFontSize(1, 1, false);
    vfd->GU7000_clearScreen();
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_setFontSize(1, 1, false);
    vfd->printat(18, 15, "<=< LOCKER KEY >=>");
    vfd->printat(9, 30, "Silahkan Finger Print... ");
    vfd->GU7000_setFontSize(1, 1, false);
    delete vfd;
}

void Displays::step1(bool c)
{
    Noritake *vfd = new Noritake(tx, rx);
    vfd->GU7000_setFontSize(1, 1, false);
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_clearScreen();
    vfd->printat(18, 15, "<=< LOCKER KEY >=>");
    wait_ms(100);
    vfd->printat(13, 30, "Tempelkan Ibutton... ");
    wait_ms(100);
    if(!c)vfd->printat(30, 45, "Ibutton Salah! ");
    vfd->GU7000_setFontSize(1, 1, false);
    delete vfd;
}

void Displays::step2(const char *str)
{
    char buf[32];
    Noritake *vfd = new Noritake(tx, rx);
    vfd->GU7000_clearScreen();
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_setFontSize(1, 1, false);
    vfd->GU7000_clearScreen();
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_setFontSize(1, 1, false);
    sprintf(buf, "Lokasi : %s", str);
    vfd->printat(18, 15, "<=< LOCKER KEY >=>");
    vfd->GU7000_setFontSize(2, 2, false);
    vfd->printat(10, 30, buf);
    wait_ms(100);
    vfd->GU7000_setFontSize(1, 1, false);
    delete vfd;
}

void Displays::step3(std::vector<string> vecBuf)
{
    string str;
    for(int i=1; i<vecBuf.size(); i++) {
        str += vecBuf[i];
        if(i != (vecBuf.size()-1)) {
            str += " - ";
        }
    }
    char buf[32];
    sprintf(buf, "Lokasi : %s", str.c_str());
    Noritake *vfd = new Noritake(tx, rx);
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_clearScreen();
    vfd->GU7000_setFontSize(1, 1, false);
    vfd->printat(18, 15, "<=< LOCKER KEY >=>");
    wait_ms(100);
    vfd->printat(10, 30, buf);
    vfd->GU7000_setFontSize(1, 1, false);
    delete vfd;
}

void Displays::step4(const char *str, bool muncul)
{
    Noritake *vfd = new Noritake(tx, rx);
    vfd->GU7000_clearScreen();
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_setFontSize(1, 1, false);
    vfd->GU7000_clearScreen();
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_setFontSize(1, 1, false);
    vfd->printat(18, 15, "<=< LOCKER KEY >=>");
    wait_ms(100);
    vfd->printat(10, 30,  "Maintenance Process");
    if(muncul) {
        wait_ms(100);
        char buf[32];
        sprintf(buf, "Lokasi : %s", str);
        vfd->GU7000_setFontSize(2, 2, false);
        vfd->printat(10, 45, buf);
        vfd->GU7000_setFontSize(1, 1, false);
    }
    vfd->GU7000_setFontSize(1, 1, false);
    delete vfd;
}

void Displays::step5(const char *str, bool muncul)
{
    Noritake *vfd = new Noritake(tx, rx);

    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_setFontSize(1, 1, false);
    vfd->GU7000_clearScreen();
    vfd->printat(18, 15, "<=< LOCKER KEY >=>");
    wait_ms(100);
    vfd->printat(8, 30,  "Unauthorized Process");
    if(muncul) {
        wait_ms(100);
        char buf[32];
        sprintf(buf, "Lokasi : %s", str);
        vfd->GU7000_setFontSize(2, 2, false);
        vfd->printat(10, 45, buf);
        vfd->GU7000_setFontSize(1, 1, false);
    }
    wait_ms(100);
    vfd->GU7000_setFontSize(1, 1, false);
    delete vfd;
}

void Displays::displaybtn(const char *_ibtn)
{
    Noritake *vfd = new Noritake(tx, rx);
    vfd->GU7000_setFontStyle(1,0);
    vfd->printat(0, 32, _ibtn);
    delete vfd;
}

void Displays::error(const int &c)
{
    Noritake *vfd = new Noritake(tx, rx);
    vfd->GU7000_setFontSize(1, 1, false);
    vfd->GU7000_setFontStyle(1,0);
    vfd->GU7000_clearScreen();
    vfd->printat(18, 15,    "<=< LOCKER KEY >=>");

    if(c == 0) {
        vfd->printat(22, 30, "Koneksi Terputus ");
    } else if(c == 4) {
        vfd->printat(24, 30, "Kesalahan Fatal ");
    } else if(c == 5) {
        vfd->printat(22, 30,  "Hubungi Dispatch ");
    } else if(c == 6) {
        vfd->printat(30, 30, "I-Button Beda ");
//        vfd->printat(0, 32, ibuttondsp.c_str());
    }
    delete vfd;
}
