#include "Audio.h"

extern Serial dbg;

double nada[10] = {0, 247, 262, 294, 330, 349, 392, 440, 494, 523};
//double nadas[16] = { 6, 6, 0, 6,
//                     0, 4, 6, 0,
//                     8, 0, 0, 0,
//                     1, 0, 0, 0 };
//
unsigned int nadas[8] = { 1, 2, 3, 4,
                          5, 6, 7, 8
                        };

Audio::Audio(PinName buzzer): _out(buzzer)
{
}

void Audio::SetVolume(double volume)
{
    vol = volume;
}

void Audio::SetDuration(unsigned int milisec)
{
    ms = milisec;
}

void Audio::PlayNote(unsigned int angka)
{
    if(angka > 8) angka -= 8;

    double Nada = nada[angka];
    PlayNote(Nada*4.24, ms, vol);
}

void Audio::mute()
{
    DigitalOut *out = new DigitalOut(_out);
    out->write(0);
    delete out;
}

void Audio::PlayNote(double frequency, double duration, double volume)
{
    PwmOut *out = new PwmOut(_out);
    out->period(1.0/frequency);
    out->write(volume/2.0);
    wait_ms(duration);
    out->write(0.0);
    delete out;
}

// -----------------------------------------------------------------------------
MyAudio::MyAudio(PinName buzz) : Audio (buzz)
{}

void MyAudio::play(const int &code)
{
    switch(code) {
        case 0 :
            mute();
            break;

        case 1 : {
            set(500, 0.7);
            playing(3);
            set(500, 0.7);
            playing(6);
        }
        break;

        case 2 : {
            set(1000, 2);
            playing(5);
            playing(2);
        }
        break;

        case 3 : {
            set(500, 0.7);
            playing(6);
        }
        break;

        default:
            set(100, 0.5);
            for(int j=0; j<8; j++) {
                playing(nadas[j]);
            }
            set();
            mute();
            break;
    }
}

void MyAudio::set(double dur, double vol)
{
    Audio::SetVolume(vol);
    Audio::SetDuration(dur);
}

void MyAudio::playing(unsigned int note)
{
    Audio::PlayNote(note);
}

void MyAudio::mute()
{
    Audio::mute();
}
