#include "Audio.h"

double nada[9] = {247, 262, 294, 330, 350, 392, 440, 494, 523};

Audio::Audio(PinName buzzer): out(buzzer)
{
}
    
void Audio::SetVolume(double volume)
{
    vol = volume;
}   

void Audio::SetDuration(unsigned int milisec)
{
    ms = milisec;
}
        
void Audio::PlayNote(unsigned int angka)
{
    if(angka > 8) angka = 8;
    
    double Nada = nada[angka];
    PlayNote(Nada*4.24, ms, vol);
}

void Audio::mute()
{
    out = 0;
}

void Audio::PlayNote(double frequency, double duration, double volume)
{
    out.period(1.0/frequency);
    out = volume/2.0;
    wait_ms(duration);
    out = 0.0;
}
