#include "mbed.h"
#include "EthernetInterface.h"
#include <string>

#define IP_CONF_PORT       50004

#define ijo 0
#define merah 1
UDPSocket sock, ip_conf, trx_ser; //gen_con,
Endpoint multi, server; //,multi_data;

extern "C" void mbed_reset();
LocalFileSystem local("local");

DigitalOut Stdby_R(LED2), Sopir_R(LED3), Res_R(LED1), MT_R(LED4), Gate(p24),
        Sleep(p11), Link_Led(p29), Act_Led(p30);
DigitalInOut Std_G(p21), Std_R(p22), Pow(p23), Spr_G(p19), Spr_R(p20), Mt_G(
        p17), Mt_R(p18), iBtn(p15);
DigitalIn print_er(p16), print_done(p12);

//Serial pc(p28, p27);
Serial dbg(USBTX, USBRX);
Serial pc(p13, p14);

char IP[16], SUBNET[16], GATEWAY[16], MCAST[16];
char PortListen[6], PortSend[6], PortHeartB[6];
char IDX[4];

int width, TICK = 0;
unsigned char ID[8], idx, idy, id_addr = 0x33, ix, er_tmp1 = 0, er_tmp2 = 0,
        sprmt = 0; // state = 1,
char text[26], ch, rx_buff[6], tx_buff[7],  //86
        hex[17] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B',
                'C', 'D', 'E', 'F' };  //,

/*Contoh format data
 <02>GI01S0123456789ABCDEF00<03>
 <02>GI01M0123456789ABCDEF00<03>
 <02> ->start
 GI -> Lokasi <G = Gate> <I = Input> <O = Output>
 01 -> ID
 S -> Supir <S = Supir> <M = MT>
 0123456789ABCDEF -> iButton data
 00 -> reserved
 <03> -> stop

 format heartbeat
 <02>GI0100000000<03>

 format validasi
 <02>V01<03>
 1, idle
 2, stdby/ idle
 3, merah/sopir
 4, bitu/ MT
 5, buka gate

 format ipconfig
 <02> 192.168.1.116, 255.255.255.0, 192.168.1.1, 192.168.1.10, 50000, 50001, 50003, GI01$<03>
 #192.168.1.116, 255.255.255.0, 192.168.1.1, 192.168.1.10, 50000, 50001, 50003, GI01$
 2, stdby
 3, merah/sopir
 4, biru MT
 */

void Standby(bool warna, bool nyala) {
    switch (nyala) {
    case 0:
        if (warna == ijo) {
            Stdby_R = 0;    // led 2
            Std_G.output();
            Std_G.write(0);
            Std_G.input();
            Std_G.mode(PullUp);
        } else if (warna == merah) {
            Std_R.output();
            Std_R.write(0);
            Std_R.input();
            Std_R.mode(PullUp);
        }
        break;
    case 1:
        if (warna == ijo) {
            Stdby_R = 1;
            Std_G.output();
            Std_G.write(1);
        } else if (warna == merah) {
            Std_R.output();
            Std_R.write(1);
        }
        break;
    }
}

void Sopir(bool warna, bool nyala) {
    switch (nyala) {
    case 0:
        if (warna == ijo) {
            Sopir_R = 0;    // led 3
            Spr_G.output();
            Spr_G.write(0);
            Spr_G.input();
            Spr_G.mode(PullUp);
        } else if (warna == merah) {
            Spr_R.output();
            Spr_R.write(0);
            Spr_R.input();
            Spr_R.mode(PullUp);
        }
        break;
    case 1:
        if (warna == ijo) {
            Sopir_R = 1;
            Spr_G.output();
            Spr_G.write(1);
        } else if (warna == merah) {
            Spr_R.output();
            Spr_R.write(1);
        }
        break;
    }
}

void eMTy(bool warna, bool nyala) {
    switch (nyala) {
    case 0:
        if (warna == ijo) {
            MT_R = 0;       // led 4
            Mt_G.output();
            Mt_G.write(0);
            Mt_G.input();
            Mt_G.mode(PullUp);
        } else if (warna == merah) {
            Mt_R.output();
            Mt_R.write(0);
            Mt_R.input();
            Mt_R.mode(PullUp);
        }
        break;
    case 1:
        if (warna == ijo) {
            MT_R = 1;
            Mt_G.output();
            Mt_G.write(1);
        } else if (warna == merah) {
            Mt_R.output();
            Mt_R.write(1);
        }
        break;
    }
}
void mbed_config_init() {
    char chr[256];
    int ilx = 0;
    unsigned char n = 0, x = 0;
    FILE *fp = fopen("/local/IPCONF.TXT", "r");
    if (fp == NULL)
        dbg.printf("Error opening file");
    else {
        //dbg.printf("File Exist!\r\n");
        do {
            ilx++;
            chr[ilx] = fgetc(fp);
            //dbg.printf("%c",chr[ilx]);
        } while (chr[ilx] != '$');
        fclose(fp);
    }
    ilx = 1;
    do {
        if (chr[ilx] == '#') {
            ilx = ilx + 1;
            n = 1;
            dbg.printf("Start file\r\n");
        } else if (chr[ilx] == ',') {
            n++;
            x = 0;
            ilx = ilx + 2;
        }
        switch (n) {
        case 0:
            break;
        case 1:
            IP[x] = chr[ilx];
            break;
        case 2:
            SUBNET[x] = chr[ilx];
            break;
        case 3:
            GATEWAY[x] = chr[ilx];
            break;
        case 4:
            MCAST[x] = chr[ilx];
            break;
        case 5:
            PortListen[x] = chr[ilx];
            break;
        case 6:
            PortSend[x] = chr[ilx];
            break;
        case 7:
            PortHeartB[x] = chr[ilx];
            break;
        case 8:
            IDX[x] = chr[ilx];
            break;
        }
        x++;
        ilx++;
    } while (chr[ilx] != '$');

    dbg.printf("IP Device         = %s\r\n", IP);
    dbg.printf("Subnet            = %s\r\n", SUBNET);
    dbg.printf("Gateway           = %s\r\n", GATEWAY);
    dbg.printf("Multicast IP      = %s\r\n", MCAST);
    dbg.printf("Server to mBed    = %s\r\n", PortListen);
    dbg.printf("mBed to Multicast = %s\r\n", PortSend);
    dbg.printf("HeartBeat Port    = %s\r\n", PortHeartB);
    dbg.printf("device IDX        = %s\r\n", IDX);
}

unsigned char reset(void) {
    for (idx = 0; idx < 8; idx++) {
        ID[idx] = 0;
    }
    ix = 0;
    iBtn.output();
    iBtn.write(0);
    wait_us(480);
    iBtn.write(1);
    iBtn.mode(PullUp);
    iBtn.input();

    for (int i = 0; i < 180; i++) {
        wait_us(1);
        if (iBtn == 0) {
            ix = 1;
        }
    }
    wait_us(1);
    if (ix == 0) {
        return 0;
    } else
        return 1;
}

int write() {
    iBtn.output();
    iBtn.write(1);
    for (idx = 0; idx < 8; idx++) {
        for (int i = 0; i < 35; i++) {
            wait_us(1);
            if (i >= 2) {
                iBtn.write((id_addr >> idx) & 1);
            } else
                iBtn.write(0);
        }
        iBtn.write(1);
    }
    wait_us(2);
    return 0;
}

int read() {
    iBtn.output();
    iBtn.write(1);
    for (idx = 0; idx < 8; idx++) {
        for (idy = 0; idy < 8; idy++) {
            width = 0;
            iBtn.output();
            iBtn.write(0);
            wait_us(1);
            iBtn.input();
            for (int i = 0; i < 35; i++) {
                wait_us(1);
                if (iBtn.read()) {
                    width++;
                }
            }
            if (width > 25) {
                ID[idx] |= (1 << idy);
            }
        }
    }

    for (idx = 0; idx < 8; idx++) {
        text[((7 - idx) * 2) + 7] = hex[ID[idx] & 0x0f];
        text[((7 - idx) * 2) + 6] = hex[(ID[idx] >> 4) & 0x0f];
    }
    std::string str;
    std::size_t found1;
    str += text;
        
    found1 = str.find("FFFFFFFFFF");
    if(found1 == std::string::npos)
    {
        found1 = str.find("000000000000");
        if(found1 == std::string::npos)
        {
            dbg.printf(text);
            dbg.printf("\r\n");
        }
    }
    return 0;
}

int cmpstr(const char *str, const char *sub) {
    int length = strlen(sub);
    if (length == 0)
        return 0;
    int count = 0;
    for (str = strstr(str, sub); str; str = strstr(str + length, sub))
        ++count;
    return count;
}

void Hartbit(unsigned char std) {
    char hb_buff[20], hb_num[10];
    static int hb;
    hb_buff[0] = IDX[0];
    hb_buff[1] = IDX[1];
    hb_buff[2] = IDX[2];
    hb_buff[3] = IDX[3];

    multi.set_address(MCAST, atoi(PortHeartB));
    hb++;

    switch (std) {
    case 0:
        //Standby(0, 1);
        if (hb < 375) {
            Sopir(0, 1);
        } else if ((hb >= 375) && (hb < 750)) {
            Sopir(0, 0);
        } else if ((hb >= 750) && (hb < 1125)) {
            Sopir(0, 1);
        } else if ((hb >= 1125) && (hb < 1500))
            Sopir(0, 0);
        if (hb >= 1500) {
            sprintf(hb_num, "%d", TICK);
            strcat(hb_buff, hb_num);
            sock.sendTo(multi, hb_buff, sizeof(hb_buff));
            hb = 0;
            TICK++;
        }
        break;
    case 1:
        Standby(0, 0);
        Standby(0, 1);
        if (hb < 750) {
            Standby(0, 1);
        } else if ((hb >= 750) && (hb < 1500)) {
            Standby(0, 0);
        } else if ((hb >= 1500) && (hb < 2250)) {
            Standby(0, 1);
        } else if ((hb >= 2250) && (hb < 3000))
            Standby(0, 0);
        if (hb >= 3000) {
            sprintf(hb_num, "%d", TICK);
            strcat(hb_buff, hb_num);
            sock.sendTo(multi, hb_buff, sizeof(hb_buff));
            hb = 0;
            TICK++;
        }

        break;
    case 2:
        Standby(0, 1);
        if (hb >= 7000) {
            sprintf(hb_num, "%d", TICK);
            strcat(hb_buff, hb_num);
            sock.sendTo(multi, hb_buff, sizeof(hb_buff));
            hb = 0;
            TICK++;
        }
        break;
    }
}

int openForce() {
    int n = sock.receiveFrom(server, rx_buff, sizeof(rx_buff));
    
    if (n != 0) {
        if ((rx_buff[1] == 'V') && (rx_buff[3] == '5')) {
            eMTy(0, 0);
            Sopir(0, 0);
            wait(1);
            Gate = 1;                                                   //BYPASS
            wait_ms(1500);                                              //BYPASS
            Gate = 0;                                                   //BYPASS
            sprmt = 0;
            tx_buff[4] = 'P';
            tx_buff[5] = '0';
            tx_buff[6] = '0';
            multi.set_address(MCAST, atoi(PortSend));
            sock.sendTo(multi, tx_buff, sizeof(tx_buff));
        } else if (rx_buff[1] == 'R') {
            tx_buff[4] = 'P';
            tx_buff[5] = '0';
            tx_buff[6] = '0';
            sprmt = 0;
            multi.set_address(MCAST, atoi(PortSend));
            sock.sendTo(multi, tx_buff, sizeof(tx_buff));
            eMTy(0, 0);
            Sopir(0, 0);
            Gate = 0;
        }
    } else {
        return 0;
    }
    return 0;
}

void write_config(char buff[90]) //
        {
    FILE *fp = fopen("/local/IPCONF.TXT", "w");
    fprintf(fp, buff);
    fclose(fp);
}

int set_IP() {
    char ptr_data;
    //server.set_address(SERVER,ER_SEND_PORT);
    //char print_rx_buff[128];
    char conf_buff[1024] = { 0 }, print_init[20] = { 0x1b, 0x40, 0x1b, 0x54,
            0x1b/*,0x57*/, 0x00, 0x1b, 0x77, 0x00, 0x12, 0x1b, 0x43, 0x00, 0x06,
            0x1b, 0x6c, 0x01, 0x12 };
    int n = ip_conf.receiveFrom(server, conf_buff, sizeof(conf_buff));
    if (n >= 0) {
        //printf("Packet from \"%s\": %s\n", server.get_address(), conf_buff);
        if (conf_buff[0] == '^') {
            if (conf_buff[1] == 'R') {
                mbed_reset();
            } else if (conf_buff[1] == 'S') {
                Sleep = 1;
                /*eMTy(0, 0);
                Sopir(0, 0);
                Standby(0, 0);*/
                Gate = 0;
                
                int stop = 0;
                while(stop != 1)
                {
                    /*eMTy(0, 0);
                    Sopir(0, 0);
                    Standby(0, 0);*/
                    Spr_G.input();
                    Spr_G.mode(PullUp);
                    
                    Mt_G.input();
                    Mt_G.mode(PullUp);
                    
                    Std_G.input();
                    Std_G.mode(PullUp);
                    
                    ip_conf.receiveFrom(server, conf_buff, sizeof(conf_buff));
                    
                    if (conf_buff[0] == '^') 
                    {
                        if (conf_buff[1] == 'W')
                        {
                            stop = 1;
                            Sleep = 0;
                        }
                        else if (conf_buff[1] == 'R')
                        {
                            stop = 0;
                        }
                        else if (conf_buff[1] == 'S')
                        {
                            stop = 0;
                        }
                        else stop = 0;
                    }
                    else if (conf_buff[0] == '2') stop = 0;
                    
                    else stop = 0;
                }
                //sock.close(true);
            } else if (conf_buff[1] == 'W') {
                Sleep = 0;
                //sock.bind(atoi(PortListen));
            }
        } else if (conf_buff[0] == '#') {
            write_config(conf_buff);
        } else if (conf_buff[0] == 0x0f) {
            dbg.printf("%s", print_init);
            pc.printf("%s", conf_buff);
            ptr_data = *strchr(conf_buff, 0x1d);
            if (ptr_data != NULL) {
                //wait(2);
                //Gate = 1;
                //wait_ms(1200);
                //Gate = 0;
                tx_buff[4] = 'D';
                tx_buff[5] = '0';
                tx_buff[6] = '1';
                multi.set_address(MCAST, atoi(PortSend));
                sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                dbg.printf("Printer Done\r\n");
            }
            //printf("printing receive..\r\n");
            //}
        } else
            return 0;
    } else {
        return 0;
    }
    return 0;
}

int main(void) {
    pc.baud(19200);
    //pc.baud(9600);
    
    mbed_config_init();
    dbg.printf("System Start \r\n");

    EthernetInterface eth;
    eth.init(IP, SUBNET, GATEWAY);
    int n = eth.connect();
    if (!n) {
        Link_Led = 1;
    } else
        Link_Led = 0;
    ip_conf.bind(IP_CONF_PORT);
    /*if (ip_conf.join_multicast_group(MCAST) != 0) {
     printf("IP conf error joining the multicast group\n");

     }*/

    ip_conf.set_blocking(false, 0);
    server.set_address(MCAST, 50002);

    sock.bind(atoi(PortListen));
    /*if (sock.join_multicast_group(MCAST) != 0) {
     printf("Error joining the multicast group\n");
     }*/

    sock.set_blocking(false, 0);

    text[0] = 2;
    text[1] = IDX[0];
    text[2] = IDX[1];
    text[3] = IDX[2];
    text[4] = IDX[3];
    text[22] = '0';
    text[23] = '0';
    text[24] = 3;
    unsigned char tmp, sndrcv = 0, tmpx = 0;
    int timeout = 0;
    dbg.printf("Device Ready\r\n");

    tx_buff[0] = IDX[0];
    tx_buff[1] = IDX[1];
    tx_buff[2] = IDX[2];
    tx_buff[3] = IDX[3];
    tx_buff[4] = 'R';
    tx_buff[5] = '0';
    //tx_buff[6] = '0';
    multi.set_address(MCAST, atoi(PortSend));
    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
    eMTy(ijo, 0);
    eMTy(merah, 0);
    Sopir(ijo, 0);
    Sopir(merah, 0);
    Standby(ijo, 0);
    Standby(merah, 0);
    Res_R = 1;
    while (true) {
        for (idx = 0; idx < 6; idx++) {
            rx_buff[idx] = 0;
        }

        switch (sndrcv) {
        case 0: {
            tmp = reset();

            if (tmp == 1) {
                if (tmpx == 0) {
                    if (sprmt == 0) {
                        Sopir(0, 1);
                    } else {
                        eMTy(0, 1);
                    }
                    wait_ms(70);
                    reset();
                    write();
                    read();
                    if (sprmt == 0) {
                        Sopir(0, 0);
                        text[5] = 'S';
                    } else {
                        eMTy(0, 0);
                        text[5] = 'M';
                    }
                    if (cmpstr(text, "F") < 10) {
                        /*if (((text[6] != 'F') && (text[7] != 'F')
                         && (text[8] != 'F') && (text[9] != 'F')
                         && (text[10] != 'F') && (text[11] != 'F'))) {*/
                        multi.set_address(MCAST, atoi(PortSend));
                        sock.sendTo(multi, text, sizeof(text));
                        sndrcv = 1;
                    }
                }
            }

            if (sprmt == 0) {
                if (sndrcv == 1) {
                    Hartbit(2);
                } else
                    Hartbit(1);
            } else if (sprmt == 1)
                //Hartbit(2);
                Hartbit(0);

            tmpx = tmp;
            openForce();
            break;
        }
        case 1: {
            sock.bind(atoi(PortListen));
            /*
             if (sock.join_multicast_group(MCAST) != 0) {
             printf("Error joining the multicast group\n");
             while (true) {
             }
             }*/
            int n = sock.receiveFrom(server, rx_buff, sizeof(rx_buff));
            if (n != 0) {
                dbg.printf("Packet from \"%s\": %s\n", server.get_address(),
                        rx_buff);
                if ((rx_buff[1] == 'V') && (rx_buff[3] == '3')) {
                    sndrcv = 0;
                    Sopir(0, 1);
                    sprmt = 1;
                    tx_buff[4] = 'O';
                    tx_buff[5] = 'K';
                    tx_buff[6] = '!';
                    multi.set_address(MCAST, atoi(PortSend));
                    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                    dbg.printf("Data S Valid..\r\n");
                } else if ((rx_buff[1] == 'A') && (rx_buff[3] == '3')) {
                    sndrcv = 0;
                    Sopir(0, 0);
                    eMTy(0, 1);
                    wait_ms(200);
                    eMTy(0, 0);
                    sprmt = 0;
                    tx_buff[4] = 'O';
                    tx_buff[5] = 'K';
                    tx_buff[6] = '!';
                    multi.set_address(MCAST, atoi(PortSend));
                    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                    dbg.printf("Data S Not Valid, but M valid, reset!!!!\r\n");
                } else if ((rx_buff[1] == 'V') && (rx_buff[3] == '4')) {
                    Sopir(0, 1);
                    eMTy(0, 1);
                    wait_ms(500);
                            /*
                                Lakukan perubahan disini menyangkut dengan:
                                    - delay lebih lama
                                    - sprmt yang ditambah
                            */
                    //sprmt = 0;
                    tx_buff[4] = 'O';
                    tx_buff[5] = 'K';
                    tx_buff[6] = '!';
                    multi.set_address(MCAST, atoi(PortSend));
                    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                    dbg.printf("Data M Valid..\r\n");
                } else if ((rx_buff[1] == 'A') && (rx_buff[3] == '4')) {
                    sndrcv = 0;
                    if (sprmt == 0) {
                        Sopir(0, 0);
                    } else {
                        Sopir(0, 1);
                    }
                    eMTy(0, 0);
                    //sprmt = 0;
                    tx_buff[4] = 'O';
                    tx_buff[5] = 'K';
                    tx_buff[6] = '!';
                    multi.set_address(MCAST, atoi(PortSend));
                    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                    dbg.printf("Data M Not Valid, refresh!!!!\r\n");
                } else if (rx_buff[1] == 'R') {
                    sndrcv = 0;
                    Sopir(0, 0);
                    eMTy(0, 0);
                    sprmt = 0;
                    tx_buff[4] = 'O';
                    tx_buff[5] = 'K';
                    tx_buff[6] = '!';
                    multi.set_address(MCAST, atoi(PortSend));
                    sock.sendTo(multi, tx_buff, sizeof(tx_buff));
                    dbg.printf("All Data Not Valid, reset!!!!\r\n");
                }
            } else {
                timeout++;
                if (timeout >= 12000) {
                    //sprmt = 0;
                    sndrcv = 0;
                    timeout = 0;
                }
            }

            //Hartbit(2);
            Stdby_R = 1;
            openForce();
            break;
            }
        }

        set_IP();
        if (!print_er) {
            er_tmp2 = 0;
            if (er_tmp1 < 3) {
                tx_buff[4] = 'X';
                tx_buff[5] = '0';
                tx_buff[6] = '1';
                multi.set_address(MCAST, atoi(PortSend));
                dbg.printf("Printer Error\r\n");
                sock.sendTo(multi, tx_buff, sizeof(tx_buff));
            } else
                er_tmp1 = 5;
            er_tmp1++;
        } else if (print_er) {
            er_tmp1 = 0;
            if (er_tmp2 < 3) {
                tx_buff[4] = 'N';
                tx_buff[5] = '0';
                tx_buff[6] = '1';
                dbg.printf("Printer Fixed\r\n");
                multi.set_address(MCAST, atoi(PortSend));
                sock.sendTo(multi, tx_buff, sizeof(tx_buff));
            } else
                er_tmp2 = 5;
            er_tmp2++;
        }

    }
}