#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832_lcd.h"
#include "SensorDataParser.h"
#include <math.h>
#include "USBMouse.h"
 
USBMouse mouse;
static EthernetInterface eth;
static C12832_LCD lcd;
static Serial pc(USBTX, USBRX);

DigitalOut led_left(LED1);
DigitalOut led_up(LED2);
DigitalOut led_right(LED3);
DigitalOut led_down(LED4);

// Configuration
#define SERVER_PORT     5555
#define MAX_BUF_SIZE    512
#define SENSE_DELTA     0.1

static void ethernet_init() {
    eth.init();
    if(eth.connect(30000) == 0)
        pc.printf("Connect OK\n\r");

    lcd.locate(0,0);
    lcd.printf("IP:%s", eth.getIPAddress());

    pc.printf("IP Address: %s\n\r", eth.getIPAddress());
}

static void main_loop() {
    UDPSocket server;
    Endpoint client;
    char buffer[MAX_BUF_SIZE];
    SENSOR_DATA pd;
    
    server.bind(SERVER_PORT);
    while (true) {
        // receive udp packet
        int n = server.receiveFrom(client, buffer, sizeof(buffer) - 1);
        if (n == sizeof(buffer) - 1) continue;
        
        buffer[n] = 0;

        // parse the packet
        if (parse_sensor_packet(buffer, &pd) == 0) continue;
        
        // accelerometer x axis
        if (pd.ax > 0) {
            led_left = 0;
            led_right = fabs(pd.ax) * 2;
        } else {
            led_left = fabs(pd.ax) * 2;
            led_right = 0;
        }

        // accelerometer y axis
        if (pd.ay > 0) {
            led_up = 0;
            led_down = fabs(pd.ay) * 2;
        } else {
            led_up = fabs(pd.ay) * 2;
            led_down = 0;
        }
        
        mouse.move(pd.ax*20, pd.ay*30);
    }
}

int main() {
    lcd.cls(); 
    ethernet_init();
    main_loop();
}
