#include "mbed.h"
 
Serial pc(USBTX, USBRX); //((USBTX, USBRX))
Serial modbus(PA_9, PA_10,9600);//(tx,rx,baud)
Serial evk(PC_10,PC_11,115200); //CN7
DigitalOut DE_RE(PA_8);
#define Read_Reg        0x03

int Max_Byte=8;
uint8_t mdb_Command_buffer[8];
uint8_t mdb_Message_buffer[8];
uint16_t RTU_CRC; 
int message_in_byte=0;
struct mdb_Data_Set {
    uint8_t Addr;
    uint8_t Data[8];
};
mdb_Data_Set mdb_Data[8]; 

//put PC input into modbus 
void PC_callback() {
    //modbus.putc(pc.getc());
   // char incomming_CMD;
  /*  while (pc.readable()){
        incomming_CMD+=pc.getc()-1;
        }
    pc.printf("Received Command :%c\r\n", incomming_CMD);*/
    
    pc.putc(pc.getc());
} 

void evk_callback() {
    pc.putc('a');
    pc.putc(evk.getc());
} 


//put modbus reply into PC
void MODBUS_callback() {
    //pc.putc(modbus.getc());
    mdb_Message_buffer[message_in_byte]=modbus.getc();
    message_in_byte++;
    
}


//MODBUS RTU CRC  
uint16_t mdbRTU_CRC(uint8_t message[], int Length)  
{
    RTU_CRC=0xffff;
    for (int pos =0 ; pos < Length ; pos++)
    {
        RTU_CRC ^= (uint16_t)message[pos];
        
        for (int i = 8; i != 0; i--)
        {
            if ((RTU_CRC & 0x0001) != 0)
                {
                    RTU_CRC >>= 1;
                    RTU_CRC ^= 0xA001;
                }
            else
                RTU_CRC >>= 1;
        }  
    }
    return RTU_CRC;
    //pc.printf("hi_mdb_CRC= %02X \r\n", hi_RTU_CRC);
    //pc.printf("lo_mdb_CRC= %02X \r\n", lo_RTU_CRC);
}  

int main() {
    pc.baud(115200);
    evk.attach(&evk_callback);
    pc.attach(&PC_callback);
    modbus.attach(&MODBUS_callback);
    uint8_t dev_Addr;
    uint16_t Hold_Reg=1;
    uint16_t Reg_len=2;
    
    while(1) {
        for (dev_Addr=1; dev_Addr<6; dev_Addr++){
            mdb_Command_buffer[0]=(uint8_t)dev_Addr;
            mdb_Command_buffer[1]=Read_Reg;
            mdb_Command_buffer[2]=(uint8_t)((Hold_Reg & 0xFF00) >> 8);
            mdb_Command_buffer[3]=(uint8_t)(Hold_Reg & 0x00FF);
            mdb_Command_buffer[4]=(uint8_t)((Reg_len & 0xFF00) >> 8);
            mdb_Command_buffer[5]=(uint8_t)(Reg_len & 0x00FF);
            //mdbRTU_CRC();
            RTU_CRC=mdbRTU_CRC(mdb_Command_buffer,6);
            //pc.printf("RTU_CRC=%04x\r\n",RTU_CRC);
            uint8_t hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            uint8_t lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            mdb_Command_buffer[6]=lo_RTU_CRC;
            mdb_Command_buffer[7]=hi_RTU_CRC;
            
            DE_RE=1;
            int byte_of_buffer;
            for (byte_of_buffer=0 ; byte_of_buffer<Max_Byte ; byte_of_buffer++)
                {
                    modbus.putc(mdb_Command_buffer[byte_of_buffer]);
                }
            
            wait_ms(2);
            message_in_byte=0;
            DE_RE =0 ;
            wait(1);
            mdb_Data[(dev_Addr)].Addr=dev_Addr;
            pc.printf("device_ID=%d\r\n", dev_Addr);
            int data_len=(int)(mdb_Message_buffer[2]);
            RTU_CRC=mdbRTU_CRC(mdb_Message_buffer,data_len+3);
            //pc.printf("RTU_CRC=%04x\r\n",RTU_CRC);
            hi_RTU_CRC = (uint8_t)((RTU_CRC & 0xFF00) >> 8);
            lo_RTU_CRC = (uint8_t)(RTU_CRC & 0x00FF);
            
            if ((mdb_Message_buffer[data_len+3]==lo_RTU_CRC)&&(mdb_Message_buffer[data_len+4]==hi_RTU_CRC))
            {
                for (int i=0 ; i<data_len ; i++)
                    {
                        mdb_Data[(dev_Addr)].Data[i]=mdb_Message_buffer[i+3];
                        //pc.putc(mdb_Message_buffer[i]);
                        pc.printf("mdb_Data= %02x\r\n",mdb_Data[(dev_Addr)].Data[i]);
                       // evk.printf("mdb_Data= %02x\r\n",mdb_Data[(dev_Addr)].Data[i]);
                        
                        
                    }
            }
        
        }
    }
}