/******************** (C) COPYRIGHT 2016 Delta Electronics, Inc. ***************
*
* File Name : Buzzer.cpp
* Authors   : Tsungta Wu - CPBG (tsungta.wu@deltaww.com)
* Version   : V.1.0.1
* Date      : 2016/Oct/14
*
*******************************************************************************/

#include "Buzzer.h"
#include "mbed.h"

using namespace mbed;
 // constructor
 /** Create a Beep object connected to the specified PwmOut pin
  *
  * @param pin PwmOut pin to connect to 
  */

Buzzer::Buzzer(PinName pin) : _pwm(pin) {
    _pwm.write(0.0);     // after creating it have to be off 
}

static float Int;
static float* Freq;
static uint16_t Num;
static uint16_t tone_cnt;

 /**next beep instantaneous 
  * usually not used 
  */
  
void Buzzer::stopBuzzer() {
  _pwm.write(0.0);
  tone_cnt = Num;
}

/** Beep with given frequency and duration.
 *
 * @param frequency - the frequency of the tone in Hz
 * @param time - the duration of the tone in seconds
 */
     
void Buzzer::simpleBeep(float freq, float time) {
    _pwm.period(1.0/freq);
    _pwm.write(0.5);            // 50% duty cycle - beep on
    tnext.attach(this,&Buzzer::stopBuzzer, time);   // time to off
}
  
void Buzzer::nextTone() {
    if (++tone_cnt < Num) {
      if (Freq[tone_cnt] > 0) {    
        _pwm.period(1.0/Freq[tone_cnt]);
        _pwm.write(0.5);            // 50% duty cycle - beep on
      } else _pwm.write(0.0);
      tnext.attach(this,&Buzzer::nextTone, Int);   // time to off
    } else _pwm.write(0.0);
}

void Buzzer::playMelody (float* tone_freq, uint16_t tone_num,float tone_time) {
    stopBuzzer();
    
    Int = tone_time;  
    Num = tone_num;
    Freq = tone_freq;
    
    tone_cnt = 0;
    _pwm.period(1.0/Freq[tone_cnt]);
    _pwm.write(0.5);            // 50% duty cycle - beep on    
    tnext.attach(this,&Buzzer::nextTone, Int);   // time to off
}




