/******************** (C) COPYRIGHT 2016 Delta Electronics, Inc. ***************
*
* File Name : Buzzer.h
* Authors   : Tsungta Wu - CPBG (tsungta.wu@deltaww.com)
* Version   : V.1.0.1
* Date      : 2016/Nov/14
*
*******************************************************************************/

/** class to make sound and play melody with a buzzer using PWM
 *   The class use a timer to change tone  - it is not blocking while playing melody
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "Buzzer.h"
 * 
 * Buzzer buzzer(p21);
 * 
 *#define tone_num   5
 *float tone[tone_num] = {262, 294, 330, 349, 392};

 * int main() {
 *       ...
 *   buzzer.simpleBeep(1000,0.5);   //beep frequency at 1KHz for 0.5 second    
 *       ...
 *   buzzer.playMelody(tone, tone_num, 0.5);    //play do re mi fa so change tone every 0.5 second
 *       ...
 * }
 * @endcode
 */

#ifndef MBED_BUZZER_H
#define MBED_BUZZER_H

#include "mbed.h"

namespace mbed {

/* Class: Buzzer
 *  A class witch uses PwmOut to play sounds.
 *  The class use a timer to change tone  - it is not blocking
 */
class Buzzer {

public:

/** Create a Buzzer object connected to the specified GPIO pin
 *
 * @param pin GPIO pin to connect to
 * @param debug GPIO uart tx pin used to print debug message (reserved)  
 */
    Buzzer (PinName pin);

/** Beep with given frequency and duration.
 *
 * @param frequency - the frequency of the tone in Hz
 * @param time - the duration of the tone in seconds
 */
    void simpleBeep (float frequency, float time);

/** Play melody with given frequency and interval.
 *
 * @param tone_freq - the frequency of each tone in Hz
 * @param tone_num - the total number of the given tones
 * @param tone_time - the duration of each tone in seconds
 */
    void playMelody (float* tone_freq, uint16_t tone_num,float tone_time);
    
/** stop the Buzzer instantaneous 
 * usually not used 
 */
    void stopBuzzer();
    
private :

    void nextTone();
    PwmOut _pwm;
    Timeout tnext;
    PinName _debug;
};

}
#endif

