/******************** (C) COPYRIGHT 2016 Delta Electronics, Inc. ***************
*
* File Name : Led.h
* Authors   : Tsungta Wu - CPBG (tsungta.wu@deltaww.com)
* Version   : V.1.0.1
* Date      : 2016/Nov/14
*
*******************************************************************************/

/** class to make control LED on/off fashion using GPIO
 *   The class use a timer to change led on/off  - it is not blocking while scheduling led on/off
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "Led.h"
 * 
 * Led led(LED1);
 * 
 *#define schedule_num   7
 *float toggle[schedule_num] = {1, 1, 1, 0, 1, 0, 1};

 * int main() {
 *       ...
 *   led.simpleBlink(0.5);   //turn on led for 0.5 second    
 *       ...
 *   led.toggleLed(toggle, schedule_num, 0.5);    //change led to on or off every 0.5 second
 *       ...
 * }
 * @endcode
 */
 
#ifndef MBED_LED_H
#define MBED_LED_H

#include "mbed.h"

namespace mbed {


/* Class: Led
 *  A class witch uses DigitalOut to on/off LED.
 *  The class use a timer to toggle  - it is not blocking
 */
class Led {

public:

    Led (PinName pin, uint8_t On_Logic = 0);
    
/** Turn on LED with given duration.
 *
 * @param time - the LED on duration in seconds
 */
    void simpleBlink (float time);

/** Toggle LED with given sequence and duration.
 *
 * @param toggle_on_off - the on/off controlling sequence 
 * @param toggle_num - the total number of the on/off operation
 * @param tonggle_time - the duration of each on/off operation in seconds
 */
    void toggleLed (uint8_t* toggle_on_off, uint16_t toggle_num, float tonggle_time);
    
/** turn off the Led instantaneous 
 * usually not used 
 */
    void offLed();
 
private :
    
    void nextToggle();
    DigitalOut _led;
    Timeout tnext;
    PinName _debug;    
};

}
#endif

