/******************** (C) COPYRIGHT 2016 Delta Electronics, Inc. ***************
*
* File Name : Led.cpp
* Authors   : Tsungta Wu - CPBG (tsungta.wu@deltaww.com)
* Version   : V.1.0.1
* Date      : 2016/Nov/14
*
*******************************************************************************/

#include "Led.h"
#include "mbed.h"

static uint8_t on_logic; 

using namespace mbed;
 
Led::Led(PinName pin, uint8_t On_Logic) : _led(pin) {
    on_logic = On_Logic;
    _led = !on_logic;//turn off when init

}

static float Int;
static uint8_t* Toggle;
static uint16_t Num;
static uint16_t toggle_cnt;

 /**turn off led instantaneous 
  * usually not used 
  */
  
void Led::offLed() {
     _led = !on_logic;
     toggle_cnt = Num;
}

/** Turn on led with given duration.
 * @param time - the duration of the tone in seconds
 */
     
void Led::simpleBlink(float time) {
    _led = on_logic;
    tnext.attach(this,&Led::offLed, time);   // time to off
}
  
void Led::nextToggle() {
    if (++toggle_cnt < Num) {
      if (Toggle[toggle_cnt] > 0)    
        _led = on_logic;
      else
        _led = !on_logic;  
      tnext.attach(this,&Led::nextToggle, Int);   // time to off
    } else offLed();
}

void Led::toggleLed (uint8_t* toggle_on_off, uint16_t toggle_num, float tonggle_time) {
    offLed();
    
    Int = tonggle_time;  
    Num = toggle_num;
    Toggle = toggle_on_off;
    
    toggle_cnt = 0;
    if (on_logic)
        _led = Toggle[toggle_cnt];
    else
        _led = !Toggle[toggle_cnt];  
    tnext.attach(this,&Led::nextToggle, Int);   // time to off    
}

