#include "mbed.h"
#include "Buzzer.h"
#include "Led.h"

Buzzer buzzer(A1);
DigitalOut led1(LED2);
Led led(LED3);

#define tone_num   5
#define schedule_num   7
float tone[tone_num] = {262, 294, 330, 349, 392};
uint8_t toggle[schedule_num] = {1,1,1,0,1,0,1};



// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main() {

    buzzer.playMelody(tone, tone_num, 0.5);
    led.toggleLed(toggle, schedule_num, 0.5);

    while (true) {
        led1 = !led1;
        wait(2);
        led.simpleBlink(1);
        printf("hello\r\n");
    }
}

