/******************** (C) COPYRIGHT 2016 Delta Electronics, Inc. ***************
*
* File Name : main.cpp
* Authors   : Tsungta Wu - CPBG (tsungta.wu@deltaww.com)
* Version   : V.1.0.0
* Date      : 2016/Nov/24
*
* This example only show the most basic WiFi operation include AP scan and connect 
* The usage of TCP/UDP socket please refer to the mbed Handbook from the link below
* https://developer.mbed.org/handbook/Socket
*
*******************************************************************************/

#include "mbed.h"
#include "EthernetInterface.h"
#include "WIFIDevice.h"

const char* ECHO_SERVER_ADDRESS = "192.168.2.13";
const int ECHO_SERVER_PORT = 1030;

void scanCallback(tstrM2mWifiscanResult result)
{
    printf("SSID: %s \n", result.au8SSID);
    printf("RSSI: %i \n", result.s8rssi);
}

int main() {

    EthernetInterface eth;
    WIFIDevice wifi;

    eth.init();

    wifi.apScan(scanCallback);
             
    wifi.setNetwork(M2M_WIFI_SEC_WPA_PSK, "TP-LINK_2.4G_TTWU", "0972753720"); 
    
    eth.connect();    

    if(wifi.is_AP_connected())
        printf("Connect Success! \n");
    else
        printf("Connect Fail! \n");    

    printf("MAC: %s\n", eth.getMACAddress());            
    printf("IP: %s\n", eth.getIPAddress());
    printf("Gateway: %s\n", eth.getGateway());
    printf("NetworkMask: %s\n", eth.getNetworkMask()); 

    UDPSocket sock;
    sock.init();
    
    Endpoint echo_server;
    echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
    
    char out_buffer[] = "Hello World";
    printf("Sending  message '%s' to server (%s)\n",out_buffer,ECHO_SERVER_ADDRESS);
    sock.sendTo(echo_server, out_buffer, sizeof(out_buffer));
    
    char in_buffer[256];    //IMPORTANT, array size MUST >= the actual received data size or set to maximum of 1400 if there is uncertainty
    int n = sock.receiveFrom(echo_server, in_buffer, sizeof(in_buffer));
    
    if(n <0)
        in_buffer[0] = '\0';//IMPORTANT, in case n = -1 when set_bloacking is timeout, prevent the illegal array in_buffer[-1] access 
    else
        in_buffer[n] = '\0';
        
    printf("Received message from server: '%s'\n", in_buffer);
    
    sock.close();
    
    eth.disconnect();                             
    
    wifi.sleep();
                                 
    while(1) {
    }
}

