#include "mbed.h"
#include "EthernetInterface.h"
#include "WIFIDevice.h"

WIFIDevice wifi;
EthernetInterface eth;
     
uint16_t ECHO_SERVER_PORT = 1030;
 
int main(void)
{   
    eth.init();
    //Default AP mode setting: ip = 192.168.1.1 / security = WEP / channel no. = 1, refer to WIFIDevice.h for detail
    if(wifi.enableAccessPoint("NNN50_AP", "0123456789") != 0)      
        printf("enableAccessPoint return error!...\n");
 
    TCPSocketServer server;
    
    while (true) {
        printf("Wait for new connection...\n");
        TCPSocketConnection client;
        server.bind(ECHO_SERVER_PORT);
        server.listen();
        server.accept(client);
        client.set_blocking(false, 10000); // Timeout after 10s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) {//disconnect with client if no tcp packet is received within blocking period or remote endpoint close the socket. 
                server.close();
                break;
            }
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\n",buffer);
            
            // reverse the message
            char temp;
            for(int f = 0, l = n-1; f<l; f++,l--){
                temp = buffer[f];
                buffer[f] = buffer[l];
                buffer[l] = temp;
                }
            
            // print reversed message to terminal
            printf("Sending message to Client: '%s'\n",buffer);
            
            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
        client.close();
    }
}
 