/******************** (C) COPYRIGHT 2016 Delta Electronics, Inc. ***************
*
* File Name : main.cpp
* Authors   : Tsungta Wu - CPBG (tsungta.wu@deltaww.com)
* Version   : V.1.0.0
* Date      : 2016/Nov/24
*
* This example only show the most basic WiFi operation include AP scan and connect 
* The usage of TCP/UDP socket please refer to the mbed Handbook from the link below
* https://developer.mbed.org/handbook/Socket
*
*******************************************************************************/

#include "mbed.h"
#include "EthernetInterface.h"
#include "WIFIDevice.h"

const char* SERVER_ADDRESS = "google.com";
const int SERVER_PORT = 443;

void scanCallback(tstrM2mWifiscanResult result)
{
    printf("SSID: %s \n", result.au8SSID);
    printf("RSSI: %i \n", result.s8rssi);
}

int main() {

    EthernetInterface eth;
    WIFIDevice wifi;

    eth.init();

    wifi.apScan(scanCallback);
             
    wifi.setNetwork(M2M_WIFI_SEC_WPA_PSK, "TWCYNPC0209_Mac_mini", "mayday55555"); 
    
    eth.connect();    

    if(wifi.is_AP_connected())
        printf("Connect Success! \n");
    else
        printf("Connect Fail! \n");    

    printf("MAC: %s\n", eth.getMACAddress());            
    printf("IP: %s\n", eth.getIPAddress());
    printf("Gateway: %s\n", eth.getGateway());
    printf("NetworkMask: %s\n", eth.getNetworkMask()); 

    TCPSocketConnection ssl_socket;

    if (wifi.is_AP_connected() && ssl_socket.connect(SERVER_ADDRESS, SERVER_PORT, true) == 0) { //set true to enable ssl socket connection
        printf("Connected to Server \n");
                    
        ssl_socket.set_blocking(false, 3500);
                    
        // Send message to server
        char buf_out[] = "GET / HTTP/1.1\r\n\r\n";
        printf("Sending  message to Server : '%s' \n",buf_out);
        ssl_socket.send(buf_out, sizeof(buf_out));
                    
        // Receive message from server
        char buf_in[1400];  //set receive buffer size to maximum of 1400 bytes

        int n = ssl_socket.receive(buf_in, 1400);
        printf("Received %i bytes from server: \n %s \n", n, buf_in);                
    } else
        printf("Unable to connect to server\n");    
    
    // Clean up
    ssl_socket.close();
    eth.disconnect();
    wifi.sleep();     
           
    while(1) {
    }
}

