#include "mbed.h"
#include "WIFIDevice.h"
#include "EthernetInterface.h"
 
WIFIDevice wifi;

uint16_t ECHO_SERVER_PORT = 5222;
 
int main(void)
{   
    printf("NNN40 init...\n");
    wifi.setAccessPoint("NNN40_TTWU", "0123456789", SECURITY_WPA2_TKIP_PSK, 2);      
    EthernetInterface eth;
    eth.init();
    wait(1);
   
    eth.connect(40000);

    printf("IP Address: %s\n",eth.getIPAddress());       
    printf("MAC Address: %s\n",eth.getMACAddress());  
    printf("Gateway Address: %s\n",eth.getGateway());       
    printf("Network Mask: %s\n",eth.getNetworkMask()); 

    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    while (true) {
        printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 5000); // Timeout after (5)s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\n",buffer);
            
            // reverse the message
            char temp;
            for(int f = 0, l = n-1; f<l; f++,l--){
                temp = buffer[f];
                buffer[f] = buffer[l];
                buffer[l] = temp;
                }
            
            // print reversed message to terminal
            printf("Sending message to Client: '%s'\n",buffer);
            
            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
        client.close();
    }
}
