#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
 
#include "WIFIDevice.h"
 
WIFIDevice wifi;
Serial pc(USBTX, USBRX);

int main() {
    char recv[50];
 
    pc.baud(115200);
    pc.printf("Init...\n");
           
    EthernetInterface eth;
    eth.init(); //Use DHCP

    // set given SSID and PW as the highest priority  
    //wifi.setNetwork("Tsungta_iPhone", "icq87001", 0);
    wifi.setNetwork("GainSpan_JS", "Delta9999", 0);
    
    eth.connect(40000);
    pc.printf("IP Address:%s\n",eth.getIPAddress());
    pc.printf("MAC Address:%s\n",eth.getMACAddress());
 
    Websocket ws("ws://192.168.15.105:8888/ws");
    ws.connect();
 
    while (1) {
        ws.send("WebSocket Hello World over Ethernet");
        ws.read(recv);
        pc.printf("read: %s\n", recv);
        wait(1.0);        
    }
}