#include "mbed.h"
#include "EthernetInterface.h"
#include "mbed_rpc.h"
#include "RPCCommand.h"
#include "HTTPServer.h"
#include "Formatter.h"
#include "RequestHandler.h"
#include "RPCType.h"

#include "WIFIDevice.h"

#define SERVER_PORT 80

#define AP_MODE_SSID "AP_MODE_SSID"
#define AP_MODE_PASSWORD "0123456789"

WIFIDevice wifi;
EthernetInterface eth;

void DeltaRequestHandler::handle(const RPCCommand& cmd, char *reply)
{
    char *pch;

    pch=strchr(cmd.get_func_name(),'/');
    cmd.get_func_name()[pch-cmd.get_func_name()] = '\0';
    
    //must call disconnect before switch between AP and STA mode
    eth.disconnect();
    
    wifi.setNetwork(cmd.get_func_name(),&(cmd.get_func_name()[pch-cmd.get_func_name()+1]),0);
    eth.init();
    printf("\n\rStart STA mode...\n");
    wait(1);

    if(eth.connect(40000) == 0)
        printf("AP connect OK...\n\r");
    else
        printf("AP connect FAIL...\n\r");

    printf("STA mode IP Address: %s\n\r",eth.getIPAddress());
    printf("STA mode MAC Address: %s\n\r",eth.getMACAddress());
    printf("STA mode Gateway Address: %s\n\r",eth.getGateway());
    printf("STA mode Network Mask: %s\n\r",eth.getNetworkMask());

    eth.disconnect();//must call disconnect before switch between AP and STA mod

    switch(cmd.get_type()) {
        case CREATE :
            printf("CREATE\n");
            putHandler.handle(cmd, reply);
            break;
        case DELETE :
            printf("CREATE\n");
            deleteHandler.handle(cmd, reply);
            break;
        case FUNCTION_CALL :
            printf("FUNCTION_CALL\n");
            getHandler.handle(cmd, reply);
            break;
        default :
           // printf("default\n");
            break;
    }

}

HTTPServer create_simple_server()
{
    HTTPServer srv;
    srv.add_request_handler("DELETE", new DeleteRequestHandler());
    srv.add_request_handler("GET", new GetRequestHandler());
    srv.add_request_handler("PUT", new PutRequestHandler());
    return srv;
}

HTTPServer create_interactive_server()
{
    HTTPServer srv(new InteractiveHTMLFormatter());
    srv.add_request_handler("GET", new ComplexRequestHandler());
    return srv;
}

HTTPServer create_delta_server()
{
    HTTPServer srv(new DeltaWifiSettingHTMLFormatter());
    srv.add_request_handler("GET", new DeltaRequestHandler());
    return srv;
}

int main(void)
{
    RPCType::instance().register_types();
    printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
    printf("\r*************** Program Start ***************\n\r");

    wifi.setAccessPoint(AP_MODE_SSID, AP_MODE_PASSWORD, SECURITY_WPA2_TKIP_PSK, 2);
    if(eth.init()) {
        printf("Error while initializing the ethernet interface.\n\r");
        return -1;
    }
    if(eth.connect(60000)) {
        printf("Error while starting the ethernet interface.\n\r");
        return -1;
    }

    printf("AP Mode IP Address is %s\n\r", eth.getIPAddress());

    HTTPServer srv = create_delta_server();

    if(!srv.init(SERVER_PORT)) {
        eth.disconnect();
        return -1;
    }

    srv.run();
    return 0;
}
