#include "RPCObjectManager.h"
#include "mbed.h"

RPCObjectManager& RPCObjectManager::instance()
{
    static RPCObjectManager om;
    return om;
}

RPCObjectManager::RPCObjectManager():
objects()
{
}

RPCObjectManager::~RPCObjectManager()
{
    for(std::list<char*>::iterator itor = objects.begin();
        itor != objects.end();
        ++itor)
        delete *itor;
}

void RPCObjectManager::store_object(char *obj_name)
{
    char *obj = new char[strlen(obj_name)+1];
    strcpy(obj, obj_name);
    obj[strlen(obj_name)] = '\0';
    objects.push_back(obj);
}

void RPCObjectManager::remove_object(char *obj_name)
{
    for(std::list<char*>::iterator itor = objects.begin();
        itor != objects.end();
        ++itor)
        if(!strcmp(obj_name, *itor))
        {
            delete *itor;
            objects.erase(itor);
            break;
        }
}

bool RPCObjectManager::lookup_object(char *obj_name)
{
    for(std::list<char*>::iterator itor = objects.begin();
        itor != objects.end();
        ++itor)
        if(!strcmp(obj_name, *itor))
            return true;
    return false;
}

bool RPCObjectManager::is_empty()
{
    return objects.empty();
}

std::list<char*>::iterator RPCObjectManager::begin()
{
    return objects.begin();
}

std::list<char*>::iterator RPCObjectManager::end()
{
    return objects.end();
}

