#include "Formatter.h"
#include "mbed.h"
#include "RPCObjectManager.h"
#include "EthernetInterface.h"

const char *SIMPLE_HTML_CODE = "\
<!DOCTYPE html>\
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\
<title>TCP Server</title>\
</head>\
 <body>";


const char* INTERACTIVE_HTML_CODE_1 = "\
<!DOCTYPE html> \
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\
<title>TCP Server</title>\
<script type=\"text/javascript\">\
var ip = \"%s\";\
function submitCreateForm()\
{\
var list = document.getElementById(\"type\");\
var type = list.options[list.selectedIndex].value;\
var name = document.getElementById(\"name\").value;\
if(name === \"\") \
return;\
var arg = document.getElementById(\"arg\").value;\
var url;\
if(arg === \"\") url = \"http://\" + ip + type + \"new?name=\" + name;\
else url = \"http://\" + ip + type + \"new?arg=\" + arg + \"&name=\" + name;\
location.href= url;\
}\
function submitCallFuncForm()\
{\
var command = document.getElementById(\"command\").value;\
if(command === \"\") \
return; \
var tmp = command.split(\' \');\
var url = tmp[0];\
if(tmp.length > 1)\
url += \"?\";\
for(var i = 1; i < tmp.length; ++i)\
{\
url += \"arg\" + i + \"=\" + tmp[i];\
if(i+1 < tmp.length)\
url += \"&\";\
}\
location.href = url;\
}\
</script>\
</head> \
<body>";

const char* INTERACTIVE_HTML_CODE_2 = "<h3>Create Object :</h3>\
<form>\
Type: <select id=\"type\">\
<option value=\"/DigitalOut/\">DigitalOut</option>\
<option value=\"/DigitalIn/\">DigitalIn</option>\
<option value=\"/DigitalInOut/\">DigitalInOut</option>\
<option value=\"/PwmOut/\">PwmOut</option>\
<option value=\"/Timer/\">Timer</option>\
</select><br>\
name: <input type=\"text\" id=\"name\"><br>\
arg(optional): <input type=\"text\" id=\"arg\">\
<p><input type=\"button\" value=\"Create\" onclick=\"javascript:submitCreateForm();\"></p>\
</form> \
 \
<h3>Call a function :</h3>\
<p>Enter an RPC command.</p>\
<form>\
Command: <input type= \"text\" id=\"command\" maxlength=127><br>\
<p><input type=\"button\" value=\"Send\" onclick=\"javascript:submitCallFuncForm();\"></p><br>\
</form>\
</body> \
</html>";

const char* DELRA_WIFI_SETTING_HTML_CODE_0 = "<!DOCTYPE html> \
<html>\
<head>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\
<title>NNN40 Wifi Module Setting</title>\
<style>\
#background {\
background: -moz-linear-gradient(top,#ffffff,#0099FF);\
border-width: 3px;\
border-style: ridge;\
width: 500px;\
height: 700px;\
border-color: #000055;\
padding: 20px\
}#title {color: #444444;}#input {margin: 10px;}\
</style><script type=\"application/javascript\">\
function reset() {\
document.getElementById(\"defaultchs\").checked = true;\
document.getElementById(\"ssid\").value = \"\";\
document.getElementById(\"password\").value = \"\";\
}function send() {var ip = \"192.168.2.1/WebSetting/\";\
var ssid = document.getElementById(\"ssid\").value;\
var pwd = document.getElementById(\"password\").value;\
location.href = \"http://\"+ip+ssid +\"/\"+pwd;}\  
</script></head><body>";

        const char* DELRA_WIFI_SETTING_HTML_CODE_1 = "<div id=\"background\">\
<div align=\"center\">\
<img src=\"https://upload.wikimedia.org/wikipedia/commons/8/8c/DELTA_Electronics_Logo.png\" width=\"354\" height=\"109\";\>\
</div><h1 id=\"title\"align=\"center\">WIFI SETTING</h1>\
<HR align=\"center\" width=\"90%\"><form id=\"input\" method=\"get\">\
<font size=\"6\" class=\"font\">Security:</font>\
<br><input id=\"defaultchs\" type=\"radio\" name=\"security\" value=\"NONE\" checked>\
NONE<input type=\"radio\" name=\"security\" value=\"WEP\">\
WEP<input type=\"radio\" name=\"security\" value=\"WPA\">\
WPA<input type=\"radio\" name=\"security\" value=\"WPA2\">\
WPA2<br> <br><font size=\"6\" class=\"font\">SSID:</font>\
<br><input id=\"ssid\" size=\"20\"  type=\"text\" name=\"ssid\">\
<br><br><font size=\"6\" class=\"font\">Password:</font>\
<br><input type=\"text\" id=\"password\" name=\"pwd\">\
<div align=\"center\"><input class=\"font\" type=\"button\" style=\"width: 160px; height: 80px; margin: 50px 40px 0px 0px; font-size: 25px\" value=\"Confirm\" onclick=\"send()\" />\
<input class=\"font\" type=\"button\" style=\"width: 160px; height: 80px; margin: 50px 40px 0px 0px; font-size: 25px\" value=\"Reset\" onclick=\"reset()\" />\
</div></form></div></body></html>" ;

static char chunk[1024];

Formatter::Formatter(int nb):
    currentChunk(0),
    nbChunk(nb)
{
}

char* Formatter::get_page(char *reply)
{
    chunk[0] = '\0';

    if(currentChunk < nbChunk) {
        get_chunk(currentChunk, reply);
        currentChunk++;
    } else
        currentChunk = 0;

    return chunk;
}

void Formatter::get_chunk(const int c, char *reply)
{
    strcat(chunk, reply);
}

SimpleHTMLFormatter::SimpleHTMLFormatter():
    Formatter()
{
}

void SimpleHTMLFormatter::get_chunk(const int c, char* reply)
{
    strcat(chunk, SIMPLE_HTML_CODE);

    if(reply != NULL && strlen(reply) != 0) {
        strcat(chunk, "RPC reply : ");
        strcat(chunk, reply);
    }

    if(!RPCObjectManager::instance().is_empty()) {
        strcat(chunk, "<ul>");
        for(std::list<char*>::iterator itor = RPCObjectManager::instance().begin();
                itor != RPCObjectManager::instance().end();
                ++itor) {
            strcat(chunk, "<li>");
            strcat(chunk, *itor);
            strcat(chunk, "</li>");
        }
        strcat(chunk, "</ul>");
    }
    strcat(chunk, "</body></html>");
}

InteractiveHTMLFormatter::InteractiveHTMLFormatter():
    Formatter(3)
{
}

void InteractiveHTMLFormatter::get_chunk(const int c, char *reply)
{
    if(c == 0)
        sprintf(chunk, INTERACTIVE_HTML_CODE_1, EthernetInterface::getIPAddress());

    else if(c == 1) {
        if(reply != NULL && strlen(reply) != 0) {
            strcat(chunk, "RPC reply : ");
            strcat(chunk, reply);
        }
        if(!RPCObjectManager::instance().is_empty()) {
            strcat(chunk, "<p>Objects created :</p>");

            strcat(chunk, "<ul>");
            for(std::list<char*>::iterator itor = RPCObjectManager::instance().begin();
                    itor != RPCObjectManager::instance().end();
                    ++itor) {
                strcat(chunk, "<li>");
                strcat(chunk, *itor);
                strcat(chunk, " (<a href=\"http://");
                strcat(chunk, EthernetInterface::getIPAddress());
                strcat(chunk, "/");
                strcat(chunk, *itor);
                strcat(chunk, "/delete\">delete</a>)");
                strcat(chunk, "</li>");
            }
            strcat(chunk, "</ul>");
        }
        strcat(chunk, " ");
    } else if(c == 2)
        strcat(chunk, INTERACTIVE_HTML_CODE_2);
}

DeltaWifiSettingHTMLFormatter::DeltaWifiSettingHTMLFormatter():
    Formatter(2)
{
}
void DeltaWifiSettingHTMLFormatter::get_chunk(const int c, char *reply)
{
    if(c == 0)
        strcat(chunk, DELRA_WIFI_SETTING_HTML_CODE_0);


    else if(c == 1) {
        strcat(chunk,DELRA_WIFI_SETTING_HTML_CODE_1);

    }
}
