#ifndef RPCCOMMAND
#define RPCCOMMAND

#include <list>
#include "mbed_rpc.h"

enum RPC_COMMAND_TYPE { INVALID, CREATE, DELETE, FUNCTION_CALL };

struct rpc_arg
{
    char *name;
    char *val;
};

class RPCCommand
{
    public :
    
        RPCCommand();

        bool decode(char *buffer);

        char* get_cmd() const;
        RPC_COMMAND_TYPE get_type() const;
        char* get_obj_name() const;
        char* get_func_name() const;

    private :
        
        char cmd[RPC_MAX_STRING];
        char* obj_name;
        char* func_name;
};

#endif

