#include "mbed.h"
#include "MXmppClient.hpp"
#include "WIFIDevice.h"

#define SSID "SSID"
#define AP_PASSWORD "0123456789"

#define USER_NAME1 "nnn40b"
#define DOMAIN "xmpp.koryo.com.tw"
#define PASSWORD1 "123456"

#define USER_NAME2 "app2"

WIFIDevice wifi;
MxmppClient mXmppClient(USER_NAME1,DOMAIN,PASSWORD1,5222);
void onGetMessage(const char*);

DigitalOut led1(p7);
DigitalOut led2(p13);

int main(void)
{
    //set given SSID and PW as the highest priority
    wifi.setNetwork(SSID, AP_PASSWORD, 0);
   
    mXmppClient.login();
    if(mXmppClient.isLogin()) {
        mXmppClient.sendMessageToClient(USER_NAME2,"Login to XMPP server");
    }
    while(true) {
        mXmppClient.setMessageTracker(onGetMessage);
    }
}

void onGetMessage(const char *msg)
{
    if(strcmp(msg,"turn on")==0) {
        mXmppClient.sendMessageToClient(USER_NAME2,"The lights is on");
        led1=1;
        led2=1;
    } else if(strcmp(msg,"turn off")==0) {
        mXmppClient.sendMessageToClient(USER_NAME2,"The lights is off");
        led1=0;
        led2=0;
    } 
}
