#include "mbed.h"
#include "BLEDevice.h"
#include "FindmeService.h"
#include "BatteryService.h"
#include "DeviceInformationService.h"
#include "DFUService.h"

#define UPDATE_PARAMS_FOR_LONGER_CONNECTION_INTERVAL 0

BLEDevice  ble;
DigitalOut led1(p0);
DigitalOut Buz(p1);

void NoAlert(void){
        Buz = 0;
    }
void MildAlert(void){
        Buz = !Buz;
        wait(2);
    }
void HighAlert(void){
        Buz = !Buz;
        wait(1);
    }

const static char     DEVICE_NAME[]        = "FindME";
static const uint16_t uuid16_list[]        = {GattService::UUID_IMMEDIATE_ALERT_SERVICE,        //Find me!
                                              GattService::UUID_BATTERY_SERVICE,
                                              GattService::UUID_DEVICE_INFORMATION_SERVICE,
                                              DFUServiceShortUUID};
                                              
static volatile bool  triggerSensorPolling = false;

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising(); // restart advertising
}

void onConnectionCallback(Gap::Handle_t handle, Gap::addr_type_t peerAddrType, const Gap::address_t peerAddr, const Gap::ConnectionParams_t *params)
{
    #if UPDATE_PARAMS_FOR_LONGER_CONNECTION_INTERVAL
    
    #define MIN_CONN_INTERVAL 250  /**< Minimum connection interval (250 ms) */
    #define MAX_CONN_INTERVAL 350  /**< Maximum connection interval (350 ms). */
    #define CONN_SUP_TIMEOUT  6000 /**< Connection supervisory timeout (6 seconds). */
    #define SLAVE_LATENCY     4

        Gap::ConnectionParams_t gap_conn_params;
        gap_conn_params.minConnectionInterval        = Gap::MSEC_TO_GAP_DURATION_UNITS(MIN_CONN_INTERVAL);
        gap_conn_params.maxConnectionInterval        = Gap::MSEC_TO_GAP_DURATION_UNITS(MAX_CONN_INTERVAL);
        gap_conn_params.connectionSupervisionTimeout = Gap::MSEC_TO_GAP_DURATION_UNITS(CONN_SUP_TIMEOUT);
        gap_conn_params.slaveLatency                 = SLAVE_LATENCY;
        ble.updateConnectionParams(handle, &gap_conn_params);
    #endif /* #if UPDATE_PARAMS_FOR_LONGER_CONNECTION_INTERVAL */
}

void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */
    triggerSensorPolling = true;
}

int main(void)
{   //NRF_CLOCK->LFCLKSRC = CLOCK_LFCLKSRC_SRC_RC;
    //NRF_CLOCK->XTALFREQ = 0x00;
    //NRF_CLOCK->EVENTS_HFCLKSTARTED  = 0;
    //NRF_CLOCK->TASKS_HFCLKSTART     = 1;
    //while (NRF_CLOCK->EVENTS_HFCLKSTARTED == 0) 
    //{// Do nothing.
    //}
    Buz = 0;
    led1 = 0;   
    Ticker ticker;
    //Ticker Buzzer;
    ticker.attach(periodicCallback, 1);

    ble.init();
    ble.onDisconnection(disconnectionCallback);
#if UPDATE_PARAMS_FOR_LONGER_CONNECTION_INTERVAL
    ble.onConnection(onConnectionCallback);
#endif /* #if UPDATE_PARAMS_FOR_LONGER_CONNECTION_INTERVAL */

    
    BatteryService              battery(ble);
    DeviceInformationService    deviceInfo(ble, "Cyntec", "Combo module", "SN1", "hw-rev1", "fw-rev1", "soft-rev1");
    FindMeService               fmService(ble);
    DFUService                  DFU(ble);
    
    /* Setup advertising. */
    /* Setting advertising string*/
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_TAG);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    /* Setting advertising parameters*/
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(Gap::MSEC_TO_ADVERTISEMENT_DURATION_UNITS(1000)); //0x20~0x4000, 0.625ms, 20ms~10.24s
    ble.setAdvertisingTimeout(0x1e);  //Timeout, stop advertising after 30sec
    ble.startAdvertising();

    while (true) {
        if (triggerSensorPolling && ble.getGapState().connected) {
            triggerSensorPolling = false;
            
            switch(fmService.AlertValue)
            {
                case 0:
                    //led1 = 0;
                    //Buz = 0;
                    NoAlert();
                    break;
                case 1:
                    //led1 = 1;
                    MildAlert();
                    break;
                case 2:
                    //Buz = 1;
                    HighAlert();
                    break;
                default:
                    led1 = 1;
                    Buz = 1;
            }
            
        } else {
            ble.waitForEvent();
        }
    }
}
