

#ifndef __BLE_FIND_ME_SERVICE_H__
#define __BLE_FIND_ME_SERVICE_H__

#include "BLEDevice.h"


class FindMeService {
public:
    uint8_t                 AlertValue;

    /**
     * @brief Constructor with 8bit Alert value.
     * @param[ref] _ble
     * @param[in] AlertValue (8-bit)
     */
    FindMeService(BLEDevice &_ble) :
        ble(_ble),
        
        Alert_Level(GattCharacteristic::UUID_ALERT_LEVEL_CHAR, (uint8_t *) &AlertValue,
                sizeof(AlertValue), sizeof(AlertValue), 
                GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE)
    {
        AlertValue = 2;
        setupService();
    }

    virtual void onDataWritten(const GattCharacteristicWriteCBParams *params) {
        uint8_t buf[2];
        uint16_t bytesRead;
        uint16_t *AlertTemp = 0;
        if (params->charHandle == Alert_Level.getValueAttribute().getHandle()) {
                
                ble.readCharacteristicValue(Alert_Level.getValueAttribute().getHandle(), buf, &bytesRead);
                memset(AlertTemp, 0, sizeof(buf));
                memcpy(AlertTemp, buf, sizeof(buf));
                AlertValue = (uint8_t)((*AlertTemp)&0xff);
        }
    }

private:
    void setupService(void) {
        static bool serviceAdded = false; /* We should only ever need to add the heart rate service once. */
        if (serviceAdded) {
            return;
        }

        GattCharacteristic *charTable[] = {&Alert_Level};
        GattService         fmService(GattService::UUID_IMMEDIATE_ALERT_SERVICE, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(fmService);
        serviceAdded = true;
        ble.onDataWritten(this, &FindMeService::onDataWritten);
    }

private:
    BLEDevice               &ble;
    GattCharacteristic      Alert_Level;

};

#endif /* #ifndef __BLE_HEART_RATE_SERVICE_H__*/