#include <mbed.h>

#include "Gap.h"
#include "command-interpreter.h"  
#include "nrf_gpio.h"

#include "ble_cli.h"

#if defined(TARGET_DELTA_DFCM_NNN50) 
#error Delta_CLI is not supported on NNN50 temporary due to the memory constraint
#endif

#define uart_buffer_size    64      //Do not increase uart_buffer_size to prevent out of memory, 
#define uart_baudrate       38400   //supported baudrate range between 1200 to 230400 (38400) for NQ620 (NNN50)
unsigned char uart_buf[uart_buffer_size];
unsigned int i = 0;

Serial console(USBTX, USBRX);

void CLI_execute() {
//    if (i>=2)
//    if (uart_buf[i-2] == 0x0D && uart_buf[i-1] == 0x0A){//detecting CR LF
        if (console.readable()) return;//retrun if it is not the end of packet
        for (int j=0; j<i; j++)
            cyntecProcessCommandInput(uart_buf[j]);
            //console.putc(uart_buf[j]);//used for debug only
        i=0;
//    }    
}
void uart_interrupt() {
    uart_buf[i++] = console.getc();
    CLI_execute();
}

int main(void)
{

    console.attach(&uart_interrupt);
    console.baud(uart_baudrate);
    console.printf("\r\nBLE initialized\r\n");
    cynBLEInitCommand();
}
