/**
 * File: core-cli.c
 * Description: Core CLI commands used by all applications regardless of profile.
 *
 * Copyright 2014 by CYNTEC Corporation.  All rights reserved.
 */

#include <stdint.h>
#include <string.h>
#include "command-interpreter.h"
#include "nrf.h"

#if (DELTA_BLE_ON == 1)
#include "ble_cli.h"
#endif
#if (DELTA_WIFI_ON == 1)
#include "wifi_cli.h"
#endif


CyntecCommandEntry cyntecCommandTable[] = {
#if (DELTA_BLE_ON == 1)
#if SIMPLE_CMD_NAME
    {"BLE", NULL, (const char*) bleCommandSets, "Command set for BLE module"},
#else
    {"cynb", NULL, (const char*) bleCommandSets, "Command set for BLE module"},
#endif
#endif

#if (DELTA_WIFI_ON == 1)
#if SIMPLE_CMD_NAME
    {"WIFI", NULL, (const char*) wifiCommandSets, "Command set for WiFi module"},
#else
    {"cynw", NULL, (const char*) wifiCommandSets, "Command set for WiFi module"},
#endif
#endif
    {NULL, NULL, NULL, NULL},
};


