#include "mbed.h"
#include "BLE.h"
#include "iBeaconScan.h"

Serial pc(TX_PIN_NUMBER, RX_PIN_NUMBER);
DigitalOut led1(LED1);
union unionType u;

void AdvertisementReportCallback(const Gap::AdvertisementCallbackParams_t *params)
{
  led1 = !led1;
  uint8_t i;
  
  if (memcmp(params->advertisingData,iBeaconPrefix,sizeof(iBeaconPrefix)) != 0)
    return;
  
  memset(u.rawData, 0 , sizeof(u.rawData));
  memcpy(u.rawData, params->advertisingData,params->advertisingDataLen);

  pc.printf("uuid:");
  for( i = 0; i < 16; i++)
    pc.printf("%02x ",u.iBeaconPayload_m.uuid[i]);
  pc.printf("\r\n");  
  pc.printf("majorNumber:%02x %02x\r\n",u.iBeaconPayload_m.majorNumber[0], u.iBeaconPayload_m.majorNumber[1]);
  pc.printf("minorNumber:%02x %02x\r\n",u.iBeaconPayload_m.minorNumber[0], u.iBeaconPayload_m.minorNumber[1]);
  pc.printf("txPower:%02x\r\n",u.iBeaconPayload_m.txPower);
}

int main(void)
{   
    led1 = 0;
    pc.baud(115200);
    pc.printf("Hello\n"); 
    
    iBeaconInit();
    iBeaconStartScan();
    wait(10);
    iBeaconStopScan();
    
    while(1) { 
    }
}
