#include "mbed.h"
#include "BLE.h"
#include "BLEControlWIFIService.h"
#include "DeviceInformationService.h"
#include "WIFIDevice.h"
#include "EthernetInterface.h"
 

#define UPDATE_PARAMS_FOR_LONGER_CONNECTION_INTERVAL 0
 
BLEDevice  ble;
WIFIDevice wifi;
EthernetInterface eth;
 
Ticker tickerSensorPolling; 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut RFSWIO(p19);

bool is_AP_connect = false;

const static char     DEVICE_NAME[]        = "TSUNGTA_BLE WCS";
static volatile bool  triggerSensorPolling = false;
 
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    ble.startAdvertising();
}

const char* PC_SERVER_ADDRESS = "172.20.10.2";
uint16_t PC_PORT = 5222;
 
int main(void)
{
    TCPSocketConnection sock;
                
    RFSWIO = 0;
    ble.init();
    ble.onDisconnection(disconnectionCallback);
 
    /* Setup primary service. */
    BLEControlWIFIService BLEWIFIService(ble, wifi);
 
    /* Setup auxiliary service. */
    DeviceInformationService deviceInfo(ble, "ARM", "Cyntec", "SN1", "hw-rev1", "fw-rev1", "soft-rev1");
 
    /* Setup advertising. */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS, (const uint8_t *)UUID_WIFI_CONFIGURATION_SERVICE, sizeof(UUID_WIFI_CONFIGURATION_SERVICE));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(1000);
    ble.startAdvertising();
 
    // infinite loop
    while (1) {
        if (ble.getGapState().connected && BLEWIFIService.is_config) {
            BLEWIFIService.is_config = false;
            //ble.shutdown();
            eth.init(); //Use DHCP
            RFSWIO = 1; //Switch RF to WiFi
            while (eth.connect()) {}
            is_AP_connect = true;

            
        } else {
            
          if (is_AP_connect) {
            if(!sock.is_connected()){ 
                sock.connect(PC_SERVER_ADDRESS,PC_PORT);
                led1 = 1;
            } else {
                char msg[] = "Hello World";
                sock.send(msg, sizeof(msg));
                wait(1);
            }
          }
            ble.waitForEvent(); // low power wait for event
        }
    }
}