#ifndef __BLE_HEART_RATE_SERVICE_H__
#define __BLE_HEART_RATE_SERVICE_H__

#include "BLE.h"
#include "WIFIDevice.h"

static const uint8_t UUID_WIFI_CONFIGURATION_SERVICE[] = { 0x44, 0x38, 0x70, 0x22, 0x40, 0x02, 0x11, 0xe4, 0x85, 0x14, 0x16, 0x42, 0x30, 0xd1, 0xdf, 0x67 };
static const uint8_t UUID_CONNECTION_STATUS_CHAR[] = { 0x44, 0x38, 0x73, 0x7e, 0x40, 0x02, 0x11, 0xe4, 0x85, 0x14, 0x16, 0x42, 0x30, 0xd1, 0xdf, 0x67 };
static const uint8_t UUID_SSID_INFO_CHAR[] = { 0x44, 0x38, 0x75, 0xd6, 0x40, 0x02, 0x11, 0xe4, 0x85, 0x14, 0x16, 0x42, 0x30, 0xd1, 0xdf, 0x67 };
static const uint8_t UUID_NETWORK_SECURITY_PASSWORD_CHAR[] = { 0x44, 0x38, 0x78, 0x1a, 0x40, 0x02, 0x11, 0xe4, 0x85, 0x14, 0x16, 0x42, 0x30, 0xd1, 0xdf, 0x67 };

static const uint8_t MAX_PAYLOAD_SIZE = 20;

class BLEControlWIFIService {
public:
    bool is_config;
    char *ssid;
    uint8_t uint_ssid[20];
    char *pw;
    uint8_t uint_pw[20];

public:

    BLEControlWIFIService(BLEDevice &_ble, WIFIDevice &_wifi) :
        ble(_ble),
        wifi(_wifi),
        is_config(false),
        statusCharacteristic(UUID_CONNECTION_STATUS_CHAR, statusPayload, 1, MAX_PAYLOAD_SIZE,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ),
        ssidCharacteristic (UUID_SSID_INFO_CHAR, ssidPayload, 1, MAX_PAYLOAD_SIZE,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ),
        pwCharacteristic (UUID_NETWORK_SECURITY_PASSWORD_CHAR, statusPayload, 1, MAX_PAYLOAD_SIZE,
                                      GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ)
    {
        setupService();
    }


    virtual void onDataWritten(const GattWriteCallbackParams *params) {
            uint8_t rssi, i;
            uint16_t bytesRead = params->len;         
            if (params->handle == statusCharacteristic.getValueAttribute().getHandle()) {
                memcpy(statusPayload, params->data, bytesRead);
        
                ble.updateCharacteristicValue(statusCharacteristic.getValueAttribute().getHandle(), statusPayload, bytesRead);
            } else if (params->handle == ssidCharacteristic.getValueAttribute().getHandle()) {
                rssi = ssidPayload[0];
                for(i=1; i<bytesRead; i++)
                    uint_ssid[i-1] = params->data[i];
                    uint_ssid[bytesRead-1] = '\0';   
                    ssid = (char*) uint_ssid; 
                    memcpy(ssidPayload, params->data, bytesRead);

                    ssidPayload[0] = rssi;      // Added by Tsungta, restore RSSI value
                    ble.updateCharacteristicValue(ssidCharacteristic.getValueAttribute().getHandle(), ssidPayload, bytesRead);
            } else if (params->handle == pwCharacteristic.getValueAttribute().getHandle()) {
                for(i=1; i<bytesRead; i++)
                    uint_pw[i-1] = params->data[i];
                    uint_pw[bytesRead-1] = '\0';
                    pw = (char*) uint_pw;
                    memcpy(pwPayload, params->data, bytesRead);
                    ble.updateCharacteristicValue(pwCharacteristic.getValueAttribute().getHandle(), pwPayload, bytesRead);
                    wifi.setNetwork(ssid, pw, 0);
                    is_config = true;
            }
    }


private:
    void setupService(void) {
        static bool serviceAdded = false; /* We should only ever need to add the heart rate service once. */
        if (serviceAdded) {
            return;
        }

        GattCharacteristic *charTable[] = {&statusCharacteristic, &ssidCharacteristic, &pwCharacteristic};
        GattService         BLEWIFIService(UUID_WIFI_CONFIGURATION_SERVICE, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));

        ble.addService(BLEWIFIService);
        serviceAdded = true;

        ble.onDataWritten(this, &BLEControlWIFIService::onDataWritten);
    }


private:
    BLEDevice               &ble;
    WIFIDevice              &wifi;
    uint8_t statusPayload[MAX_PAYLOAD_SIZE];
    uint8_t ssidPayload[MAX_PAYLOAD_SIZE];
    uint8_t pwPayload[MAX_PAYLOAD_SIZE];
    
    GattCharacteristic                      statusCharacteristic;
    GattCharacteristic                      ssidCharacteristic;
    GattCharacteristic                      pwCharacteristic;
};

#endif /* #ifndef __BLE_HEART_RATE_SERVICE_H__*/
