/* Copyright (c) 2009 Nordic Semiconductor. All Rights Reserved.
 *
 * The information contained herein is property of Nordic Semiconductor ASA.
 * Terms and conditions of usage are described in detail in NORDIC
 * SEMICONDUCTOR STANDARD SOFTWARE LICENSE AGREEMENT.
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRANTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *df
 */

#include <stdbool.h>
#include <stdint.h>

#include <mbed.h>
#include "uvis25.h"

I2C i2c_uvi(SDA, SCL);    //SDA, SCL

static const char uvis25_expected_who_am_i = 0xCAU; //!< Expected value to get from WHO_AM_I register.

bool uvis25_init(void)
{   
  bool transfer_succeeded = true;

  i2c_uvi.frequency(400000);
    uvis25_register_write(0x20 , 0x01); 
                                
  // Read and verify product ID
  transfer_succeeded &= uvis25_verify_product_id();

  return transfer_succeeded;
}

bool uvis25_verify_product_id(void)
{
    char who_am_i[1];
    uvis25_register_read(UVIS25_ADDRESS_WHO_AM_I, &who_am_i[0], 1);
    if (who_am_i[0] != uvis25_expected_who_am_i) return false;
    else return true;
}

void uvis25_register_write(uint8_t register_address, uint8_t value)
{   
    char w2_data[2];
    
    w2_data[0] = register_address;
    w2_data[1] = value;
    i2c_uvi.write(UVIS25_WriteADDE, w2_data, 2);      

}

void uvis25_register_read(char register_address, char *destination, uint8_t number_of_bytes)
{
  i2c_uvi.write(UVIS25_WriteADDE, &register_address, 1, 1);
  i2c_uvi.read(UVIS25_WriteADDE, destination, number_of_bytes);  
}
               
    
uint8_t UVIS25_ReadUVI(void)
{
    char UVI_reading;
    uvis25_register_read(0x28, &UVI_reading, 1);
    return (uint8_t) UVI_reading;
}
