/* Copyright (c) 2009 Nordic Semiconductor. All Rights Reserved.
 *
 * The information contained herein is property of Nordic Semiconductor ASA.
 * Terms and conditions of usage are described in detail in NORDIC
 * SEMICONDUCTOR STANDARD SOFTWARE LICENSE AGREEMENT.
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRANTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 */

#ifndef UVIS25_H
#define UVIS25_H

/*lint ++flb "Enter library region" */

#include <stdbool.h>
#include <stdint.h>



#define UVIS25_ADDRESS_WHO_AM_I (0x0FU) //!< WHO_AM_I register identifies the device. Expected value is 0xCA.

#define UVIS25_WriteADDE         0x8E
#define UVIS25_ReadADDE          0x8F
#define UVIS25_UVI_OUT    0x28

bool uvis25_init(void);

void uvis25_register_write(uint8_t register_address, const uint8_t value);

void uvis25_register_read(char register_address, char *destination, uint8_t number_of_bytes);

bool uvis25_verify_product_id(void);

uint8_t UVIS25_ReadUVI(void);

#endif /* UVIS25_H */
