#include "mbed.h"
#include "BLE.h"
#include "DeviceInformationService.h"
#include "GlucoseService.h"
 
BLEDevice  ble;
DigitalOut led01(LED1);
Serial uart(p25,p23);
 
const static char     DEVICE_NAME[]        = "Glucose Machine";
static const uint16_t uuid16_list[]        = {GattService::UUID_GLUCOSE_SERVICE,
                                              GattService::UUID_DEVICE_INFORMATION_SERVICE};
static volatile bool  triggerSensorPolling = false;
 
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    ble.startAdvertising(); // restart advertising
}
 
void periodicCallback(void)
{
    led01 = !led01; /* Do blinky on LED1 while we're waiting for BLE events */
    triggerSensorPolling = true;
}
 
int main(void)
{   uart.printf("Starting Glucose Service\n");
    led01 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
 
    ble.init();
    ble.onDisconnection(disconnectionCallback);
 
    /* Setup primary service. */
    float glucoseValue = 100.0f; // 100 Kg/L
    GlucoseService GluService(ble, glucoseValue);
 
    /* Setup auxiliary service. */
    DeviceInformationService deviceInfo(ble, "ARM", "Model1", "SN1", "hw-rev1", "fw-rev1", "soft-rev1");
    /* Setup advertising. */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.accumulateAdvertisingPayload(GapAdvertisingData::GENERIC_GLUCOSE_METER);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(1000);
    ble.startAdvertising();
 
    while (1) {
        if (triggerSensorPolling && ble.getGapState().connected) {
            triggerSensorPolling = false;
            glucoseValue = glucoseValue + 1.0f;
            GluService.updateGlucoseMeasurement(glucoseValue);
            if (glucoseValue > 175.0f) {
                glucoseValue = 100.0f;
            }          
            if(GluService.is_GluReceived()){
                uint8_t *RxBuffer;
                RxBuffer = GluService.getControlPoint();
                GluService.CleanFlag();
                printf("Receive data Op Code = %d\n", RxBuffer[0]-48);
                printf("Receive data Operator = %d\n", RxBuffer[1]-48);
                printf("Receive data Operand[0] = %d\n", RxBuffer[2]-48);
                printf("Receive data Operand[1] = %d\n", RxBuffer[3]-48);
                }
        } else {
            ble.waitForEvent();
        }
    }
}