#include "mbed.h"
#include "mDot.h"
#include "CommandTerminal.h"

Serial debug(USBTX, USBRX);

mts::MTSSerial serial(XBEE_DOUT, XBEE_DIN, 512, 512);
DigitalOut led(LED1);
Ticker tick;

void tock() {
    led = !led;
}

int main()
{
    debug.baud(115200);

    tick.attach(&tock, 0.5);

    mDot* dot = mDot::getInstance();

    debug.baud(dot->getDebugBaud());
    serial.baud(dot->getBaud());

    CommandTerminal term(serial, dot);

    term.start();
}
