#include "CmdTxInverted.h"

CmdTxInverted::CmdTxInverted(mDot* dot, mts::MTSSerial& serial) :
        Command(dot, "Set Tx inverted", "AT+TXI", "Set Tx signal inverted, (default:off)"), _serial(serial)
{
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "(0,1)";
    _queryable = true;
}

uint32_t CmdTxInverted::action(std::vector<std::string> args)
{
    if (args.size() == 1)
    {
        if (_dot->getVerbose())
            _serial.writef("Tx Inverted: ");

        _serial.writef("%d\r\n", _dot->getTxInverted());
    }
    else if (args.size() == 2)
    {
        int32_t code;
        bool invert = args[1] == "1";
        if ((code = _dot->setTxInverted(invert)) != mDot::MDOT_OK)
        {
            std::string error = mDot::getReturnCodeString(code) + " - " + _dot->getLastError();
            setErrorMessage(error);
            return 1;
        }
    }

    return 0;
}

bool CmdTxInverted::verify(std::vector<std::string> args)
{
    if (args.size() == 1)
        return true;

    if (args.size() == 2)
    {
        if (!(args[1] == "0" || args[1] == "1")) {
            setErrorMessage("Invalid parameter, expects (0: off, 1: on)");
            return false;
        }

        return true;
    }

    setErrorMessage("Invalid arguments");
    return false;
}

