#include "CmdTxChannel.h"

CmdTxChannel::CmdTxChannel(mDot* dot, mts::MTSSerial& serial)
:
  Command(dot, "Tx Channels", "AT+TXCH", "List Tx channel frequencies for sub-band"),
  _serial(serial) {
    _help = std::string(text()) + ": " + std::string(desc());
    _usage = "TABLE";
    _queryable = true;
}

uint32_t CmdTxChannel::action(std::vector<std::string> args) {
    if (args.size() == 1) {
        std::vector<uint32_t> channels = _dot->getChannels();

        for (int i = 0; i < 8; i++) {
            _serial.writef("%d: %d 125k\r\n", i, channels[i]);
        }

        if (_dot->getFrequencyBand() == mDot::FB_868) {
            _serial.writef("D: %d 125k\r\n", channels[8]);
        } else {
            if (_dot->getVerbose())
                _serial.writef("Tx Channels: \r\n");

            _serial.writef("U: %d 500k\r\n", channels[8]);
            _serial.writef("D: %d 500k\r\n", channels[9]);
        }
    }

    return 0;
}

